/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import java.io.File;
import org.glassfish.embeddable.GlassFishVariable;

public class SSLParams {
    private File trustStore;
    private String trustStorePwd;
    private String trustStoreType;
    private String trustAlgorithm = "SunX509";
    private String keyAlgorithm;
    private String keyStoreType;
    private String keyStorePassword;
    private File keyStore;
    private String protocol = "TLS";
    private String[] enabledCiphers = new String[5];
    private String[] enabledProtocols = new String[5];
    private String trustMaxCertLength;
    private String certNickname;
    private String clientAuthEnabled;
    private String clientAuth;
    private String crlFile;
    private String ssl2Ciphers;
    private Boolean ssl2Enabled = false;
    private Boolean ssl3Enabled = true;
    private String ssl3TlsCiphers;
    private Boolean tlsEnabled = true;
    private Boolean tls11Enabled = true;
    private Boolean tls12Enabled = true;
    private Boolean tls13Enabled = true;
    private Boolean tlsRollBackEnabled = false;

    public SSLParams(File truststore, String trustStorePwd, String trustStoreType) {
        this.trustStore = truststore;
        this.trustStorePwd = trustStorePwd;
        this.trustStoreType = trustStoreType;
    }

    public SSLParams() {
    }

    public File getTrustStore() {
        if (this.trustStore != null) {
            return this.trustStore;
        }
        String path = System.getProperty(GlassFishVariable.TRUSTSTORE_FILE.getSystemPropertyName());
        this.trustStore = path == null ? null : new File(path);
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        if (this.trustStorePwd != null) {
            return this.trustStorePwd;
        }
        this.trustStorePwd = System.getProperty(GlassFishVariable.TRUSTSTORE_PASSWORD.getSystemPropertyName(), "changeit");
        return this.trustStorePwd;
    }

    public String getTrustStoreType() {
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        this.trustStoreType = System.getProperty(GlassFishVariable.TRUSTSTORE_TYPE.getSystemPropertyName(), "PKCS12");
        return this.trustStoreType;
    }

    String getTrustMaxCertLength() {
        if (this.trustMaxCertLength == null) {
            return "5";
        }
        return this.trustMaxCertLength;
    }

    public String getTrustAlgorithm() {
        return this.trustAlgorithm;
    }

    public void setTrustAlgorithm(String algorithm) {
        this.trustAlgorithm = algorithm;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        this.enabledCiphers = enabledCiphers;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setTrustMaxCertLength(String maxLength) {
        this.trustMaxCertLength = maxLength;
    }

    public String getCertNickname() {
        return this.certNickname;
    }

    public void setCertNickname(String certNickname) {
        this.certNickname = certNickname;
    }

    public String getClientAuthEnabled() {
        return this.clientAuthEnabled;
    }

    public void setClientAuthEnabled(String clientAuthEnabled) {
        this.clientAuthEnabled = clientAuthEnabled;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String algorithm) {
        this.keyAlgorithm = algorithm;
    }

    public String getKeyStoreType() {
        if (this.keyStoreType != null) {
            return this.keyStoreType;
        }
        this.keyStoreType = System.getProperty(GlassFishVariable.KEYSTORE_TYPE.getSystemPropertyName(), "PKCS12");
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStorePassword() {
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        this.keyStorePassword = System.getProperty(GlassFishVariable.KEYSTORE_PASSWORD.getSystemPropertyName(), "changeit");
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
    }

    public File getKeyStore() {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        String path = System.getProperty(GlassFishVariable.KEYSTORE_FILE.getSystemPropertyName());
        this.keyStore = path == null ? null : new File(path);
        return this.keyStore;
    }

    public void setKeyStore(String location) {
        this.keyStore = new File(location);
    }

    public String getSsl2Ciphers() {
        return this.ssl2Ciphers;
    }

    public void setSsl2Ciphers(String ssl2Ciphers) {
        this.ssl2Ciphers = ssl2Ciphers;
    }

    public Boolean getSsl2Enabled() {
        return this.ssl2Enabled;
    }

    public void setSsl2Enabled(String ssl2Enabled) {
        this.ssl2Enabled = Boolean.parseBoolean(ssl2Enabled);
    }

    public Boolean getSsl3Enabled() {
        return this.ssl3Enabled;
    }

    public void setSsl3Enabled(String ssl3Enabled) {
        this.ssl3Enabled = Boolean.parseBoolean(ssl3Enabled);
    }

    public String getSsl3TlsCiphers() {
        return this.ssl3TlsCiphers;
    }

    public void setSsl3TlsCiphers(String ssl3TlsCiphers) {
        this.ssl3TlsCiphers = ssl3TlsCiphers;
    }

    public Boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    public Boolean getTls11Enabled() {
        return this.tls11Enabled;
    }

    public Boolean getTls12Enabled() {
        return this.tls12Enabled;
    }

    public Boolean getTls13Enabled() {
        return this.tls13Enabled;
    }

    public void setTlsEnabled(String tlsEnabled) {
        this.tlsEnabled = Boolean.parseBoolean(tlsEnabled);
    }

    public void setTls11Enabled(String tls11Enabled) {
        this.tls11Enabled = Boolean.parseBoolean(tls11Enabled);
    }

    public void setTls12Enabled(String tls12Enabled) {
        this.tls12Enabled = Boolean.parseBoolean(tls12Enabled);
    }

    public void setTls13Enabled(String tls13Enabled) {
        this.tls13Enabled = Boolean.parseBoolean(tls13Enabled);
    }

    public Boolean getTlsRollbackEnabled() {
        return this.tlsRollBackEnabled;
    }

    public void setTlsRollbackEnabled(String tlsRollBackEnabled) {
        this.tlsRollBackEnabled = Boolean.parseBoolean(tlsRollBackEnabled);
    }
}

