/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.ejb.containers.BaseContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.logging.LogDomains;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.startup.EjbApplication;

public class SingletonLifeCycleManager {
    private static final Logger LOG = LogDomains.getLogger(SingletonLifeCycleManager.class, (String)"jakarta.enterprise.system.container.ejb");
    private final Map<String, Set<String>> singletonDependencies = new HashMap<String, Set<String>>();
    private final Set<AbstractSingletonContainer> initializedSingletons = Collections.newSetFromMap(new LinkedHashMap());
    private final Map<String, AbstractSingletonContainer> containers = new HashMap<String, AbstractSingletonContainer>();
    private final Map<String, EjbApplication> applications = new HashMap<String, EjbApplication>();
    private final boolean initializeInOrder;

    SingletonLifeCycleManager(boolean initializeInOrder) {
        this.initializeInOrder = initializeInOrder;
    }

    void addSingletonContainer(EjbApplication application, AbstractSingletonContainer container) {
        Set<String> dependsOn = Collections.newSetFromMap(new LinkedHashMap());
        EjbSessionDescriptor ejbSession = (EjbSessionDescriptor)container.getEjbDescriptor();
        String normalizedName = this.normalizeSingletonName(ejbSession);
        container.setSingletonLifeCycleManager(this);
        Arrays.stream(ejbSession.getDependsOn()).map(name -> this.resolveSingleton((String)name, ejbSession)).forEachOrdered(dependsOn::add);
        LOG.log(Level.FINE, () -> "Partial order of dependent(s). " + normalizedName + " => {" + String.join((CharSequence)", ", dependsOn) + "}");
        this.addDependencies(normalizedName, dependsOn);
        this.containers.put(normalizedName, container);
        this.applications.put(normalizedName, application);
    }

    private String normalizeSingletonName(EjbDescriptor ejb) {
        return ejb.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri() + "#" + ejb.getName();
    }

    private String resolveSingleton(String name, EjbDescriptor ejb) {
        String resolvedName;
        block6: {
            Application application;
            EjbBundleDescriptorImpl ejbBundle;
            block5: {
                resolvedName = null;
                ejbBundle = ejb.getEjbBundleDescriptor();
                application = ejbBundle.getApplication();
                boolean fullyQualified = name.contains("#");
                if (!fullyQualified) break block5;
                int index = name.indexOf("#");
                String ejbName = name.substring(index + 1);
                String relativeJarPath = name.substring(0, index);
                BundleDescriptor bundle = application.getRelativeBundle((BundleDescriptor)ejbBundle, relativeJarPath);
                if (bundle == null) break block6;
                resolvedName = bundle.getModuleDescriptor().getArchiveUri() + "#" + ejbName;
                break block6;
            }
            if (ejbBundle.hasEjbByName(name)) {
                resolvedName = ejbBundle.getModuleDescriptor().getArchiveUri() + "#" + name;
            } else if (name.matches("^[^/]+/[^/]+$")) {
                int index = name.indexOf("/");
                String ejbName = name.substring(index + 1);
                String moduleName = name.substring(0, index);
                for (EjbBundleDescriptor bundle : application.getBundleDescriptors(EjbBundleDescriptor.class)) {
                    if (!Objects.equals(moduleName, bundle.getModuleDescriptor().getModuleName()) || !bundle.hasEjbByName(ejbName)) continue;
                    resolvedName = bundle.getModuleDescriptor().getArchiveUri() + "#" + ejbName;
                    break;
                }
            }
        }
        if (resolvedName == null) {
            throw new IllegalStateException("Invalid @DependsOn value = " + name + " for Singleton " + ejb.getName());
        }
        return resolvedName;
    }

    void doStartup(EjbApplication application) {
        for (EjbDescriptor ejb : application.getEjbBundleDescriptor().getEjbs()) {
            EjbSessionDescriptor ejbSession;
            if (!(ejb instanceof EjbSessionDescriptor) || !(ejbSession = (EjbSessionDescriptor)ejb).isSingleton() || !ejbSession.getInitOnStartup()) continue;
            String normalizedName = this.normalizeSingletonName(ejbSession);
            this.initializeSingleton(this.containers.get(normalizedName));
        }
    }

    void doShutdown() {
        new ArrayDeque<AbstractSingletonContainer>(this.initializedSingletons).descendingIterator().forEachRemaining(BaseContainer::onShutdown);
    }

    public void initializeSingleton(AbstractSingletonContainer container) {
        if (this.initializedSingletons.contains(container)) {
            return;
        }
        String normalizedName = this.normalizeSingletonName(container.getEjbDescriptor());
        Collection<String> dependsOn = this.computeDependencies(normalizedName);
        for (String dependency : dependsOn) {
            EjbApplication application;
            AbstractSingletonContainer dependencyContainer = this.containers.get(dependency);
            if (this.initializedSingletons.contains(dependencyContainer)) continue;
            if (this.initializeInOrder && !(application = this.applications.get(dependency)).isStarted()) {
                LOG.log(Level.WARNING, () -> {
                    StringJoiner orderMessage = new StringJoiner(" -> ");
                    dependsOn.stream().takeWhile(d -> !d.equals(dependency)).forEachOrdered(orderMessage::add);
                    return "Partial order of singleton beans involved in this: " + String.valueOf(orderMessage.add(dependency));
                });
                String errorMessage = "application.xml specifies module initialization ordering but " + normalizedName + "depends on " + dependency + "which is in a module that hasn't been started yet";
                throw new RuntimeException(errorMessage);
            }
            LOG.log(Level.FINE, "SingletonLifeCycleManager: initializeSingleton: {0}", dependency);
            dependencyContainer.instantiateSingletonInstance();
            this.initializedSingletons.add(dependencyContainer);
        }
        LOG.log(Level.FINE, "SingletonLifeCycleManager: initializeSingleton: {0}", normalizedName);
        container.instantiateSingletonInstance();
        this.initializedSingletons.add(container);
    }

    void addDependencies(String singleton, Set<String> dependsOn) {
        if (!dependsOn.isEmpty()) {
            this.singletonDependencies.putIfAbsent(singleton, dependsOn);
        }
    }

    Collection<String> computeDependencies(String singleton) {
        if (!this.hasDependencies(singleton)) {
            return Set.of();
        }
        Set<String> dependsOn = Collections.newSetFromMap(new LinkedHashMap());
        ArrayDeque<String> recursiveQueue = new ArrayDeque<String>();
        HashSet<String> visited = new HashSet<String>();
        recursiveQueue.addLast(singleton);
        while (!recursiveQueue.isEmpty()) {
            String current = (String)recursiveQueue.peekLast();
            if (visited.contains(current)) {
                dependsOn.add(current);
                recursiveQueue.removeLast();
                continue;
            }
            visited.add(current);
            for (String dependency : this.singletonDependencies.get(current)) {
                if (this.hasDependencies(dependency)) {
                    if (visited.contains(dependency)) {
                        if (!recursiveQueue.contains(dependency)) continue;
                        String errorMessage = "Cyclic dependency: " + current + " => " + dependency + "? ";
                        String cyclicMessage = this.buildCyclicMessage(dependency, current);
                        throw new IllegalArgumentException(errorMessage + cyclicMessage);
                    }
                    recursiveQueue.remove(dependency);
                    recursiveQueue.addLast(dependency);
                    continue;
                }
                dependsOn.add(dependency);
            }
        }
        dependsOn.remove(singleton);
        return dependsOn;
    }

    private boolean hasDependencies(String singleton) {
        return this.singletonDependencies.containsKey(singleton);
    }

    private String buildCyclicMessage(String tail, String head) {
        ArrayList<String> cyclicMessage = new ArrayList<String>();
        for (List<String> path : this.findDirectedPaths(tail, head)) {
            cyclicMessage.add(String.join((CharSequence)" => ", path));
        }
        return String.join((CharSequence)"; ", cyclicMessage);
    }

    private List<List<String>> findDirectedPaths(String tail, String head) {
        ArrayList<List<String>> directedPaths = new ArrayList<List<String>>();
        ArrayDeque<String> recursiveQueue = new ArrayDeque<String>();
        HashSet<String> visited = new HashSet<String>();
        recursiveQueue.addLast(tail);
        while (!recursiveQueue.isEmpty()) {
            String current = (String)recursiveQueue.peekLast();
            if (visited.contains(current)) {
                recursiveQueue.removeLast();
                visited.remove(current);
                continue;
            }
            visited.add(current);
            for (String dependency : this.singletonDependencies.get(current)) {
                if (!this.hasDependencies(dependency)) continue;
                if (dependency.equals(head)) {
                    ArrayList<String> path = new ArrayList<String>();
                    recursiveQueue.stream().filter(visited::contains).forEachOrdered(path::add);
                    path.add(dependency);
                    directedPaths.add(path);
                    continue;
                }
                recursiveQueue.addLast(dependency);
            }
        }
        return directedPaths;
    }
}

