/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.apache.derby.tools.dblook;

public class Logs {
    private static PrintWriter logFile = null;
    private static PrintWriter ddlFile = null;
    private static String stmtEnd;
    private static boolean verbose;
    private static boolean atLeastOneDebug;

    public static boolean initLogs(String string, String string2, boolean bl, boolean bl2, String string3) {
        try {
            logFile = new PrintWriter(new FileOutputStream(string, bl));
            ddlFile = string2 == null ? null : new PrintWriter(new FileOutputStream(string2, bl));
            verbose = bl2;
            stmtEnd = string3;
            atLeastOneDebug = false;
        }
        catch (IOException iOException) {
            System.out.println("Error initializing log file(s): " + iOException);
            return false;
        }
        return true;
    }

    public static void report(String string) {
        if (ddlFile == null) {
            System.out.println("-- " + string);
        } else {
            ddlFile.println("-- " + string);
        }
    }

    public static void reportString(String string) {
        Logs.report(string);
    }

    public static void reportMessage(String string) {
        Logs.reportMessage(string, (String[])null);
    }

    public static void reportMessage(String string, String string2) {
        Logs.reportMessage(string, new String[]{string2});
    }

    public static void reportMessage(String string, String[] stringArray) {
        String string2 = dblook.lookupMessage(string, stringArray);
        Logs.report(string2);
    }

    public static void debug(Exception exception) {
        exception.printStackTrace(logFile);
        if (verbose) {
            exception.printStackTrace(System.err);
        }
        atLeastOneDebug = true;
    }

    public static void debug(String string, String string2) {
        String string3 = string;
        if (string2 != null) {
            string3 = dblook.lookupMessage(string, new String[]{string2});
        }
        logFile.println("-- **--> DEBUG: " + string3);
        if (verbose) {
            System.err.println("-- **--> DEBUG: " + string3);
        }
        atLeastOneDebug = true;
    }

    public static void debug(String string, String[] stringArray) {
        String string2 = string;
        if (stringArray != null) {
            string2 = dblook.lookupMessage(string, stringArray);
        }
        logFile.println("-- **--> DEBUG: " + string2);
        if (verbose) {
            System.err.println("-- **--> DEBUG: " + string2);
        }
        atLeastOneDebug = true;
    }

    public static String unRollExceptions(SQLException sQLException) {
        String string = sQLException.getMessage() + "\n";
        if (sQLException.getNextException() != null) {
            return string + Logs.unRollExceptions(sQLException.getNextException());
        }
        return string;
    }

    public static void writeToNewDDL(String string) {
        if (ddlFile == null) {
            System.out.print(string);
        } else {
            ddlFile.print(string);
        }
    }

    public static void writeStmtEndToNewDDL() {
        if (ddlFile == null) {
            System.out.println(stmtEnd);
        } else {
            ddlFile.println(stmtEnd);
        }
    }

    public static void writeNewlineToNewDDL() {
        if (ddlFile == null) {
            System.out.println();
        } else {
            ddlFile.println();
        }
    }

    public static boolean cleanup() {
        try {
            if (atLeastOneDebug) {
                dblook.writeVerboseOutput("DBLOOK_AtLeastOneDebug", null);
            }
            logFile.close();
            if (ddlFile != null) {
                ddlFile.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Error releasing resources: " + exception);
            return false;
        }
        return true;
    }
}

