/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.jdbc;

import java.io.Serializable;
import java.util.Optional;

public class SQLTraceRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long threadID;
    private String threadName;
    private String poolName;
    private String applicationName;
    private String moduleName;
    private String className;
    private String methodName;
    private long timeStamp;
    private Object[] params;
    private String sqlQuery;
    private StackWalker.StackFrame callingApplicationMethod;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public void setThreadID(long threadID) {
        this.threadID = threadID;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public Optional<String> getSqlQuery() {
        return Optional.ofNullable(this.sqlQuery);
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Optional<StackWalker.StackFrame> getCallingApplicationMethod() {
        return Optional.ofNullable(this.callingApplicationMethod);
    }

    public void setCallingApplicationMethod(StackWalker.StackFrame callingApplicationMethod) {
        this.callingApplicationMethod = callingApplicationMethod;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolName=").append(this.getPoolName()).append(" | ");
        sb.append("ThreadID=").append(this.getThreadID()).append(" | ");
        sb.append("ThreadName=").append(this.getThreadName()).append(" | ");
        sb.append("TimeStamp=").append(this.getTimeStamp()).append(" | ");
        sb.append("SQL=").append(this.getSqlQuery()).append(" | ");
        sb.append("AppName=").append(this.getApplicationName()).append(" | ");
        sb.append("ModuleName=").append(this.getModuleName()).append(" | ");
        sb.append("ClassName=").append(this.getClassName()).append(" | ");
        sb.append("MethodName=").append(this.getMethodName()).append(" | ");
        if (this.params != null && this.params.length > 0) {
            int index = 0;
            for (Object param : this.params) {
                sb.append("arg[").append(index++).append("]=").append(param != null ? param.toString() : "null").append(" | ");
            }
        }
        if (this.callingApplicationMethod == null) {
            sb.append("CallingMethod=(null)").append(" | ");
        } else {
            sb.append("CallingMethod=").append(this.callingApplicationMethod).append(" | ");
        }
        return sb.toString();
    }
}

