/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.protocol.NotLocalLocalCRDImpl;
import com.sun.corba.ee.impl.transport.ContactInfoImpl;
import com.sun.corba.ee.impl.transport.ContactInfoListIteratorImpl;
import com.sun.corba.ee.impl.transport.SharedCDRContactInfoImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.LoadBalancingComponent;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.trace.IsLocal;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.ContactInfoList;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.pfl.basic.func.UnaryPredicate;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
@IsLocal
public class ContactInfoListImpl
implements ContactInfoList {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected ORB orb;
    private ReadWriteLock lcrdLock = new ReentrantReadWriteLock();
    protected LocalClientRequestDispatcher localClientRequestDispatcher;
    protected IOR targetIOR;
    protected IOR effectiveTargetIOR;
    protected List<ContactInfo> effectiveTargetIORContactInfoList;
    protected ContactInfo primaryContactInfo;
    private boolean usePerRequestLoadBalancing = false;
    private int startCount = 0;
    private UnaryPredicate<ContactInfo> testPred = new UnaryPredicate<ContactInfo>(){

        public boolean evaluate(ContactInfo arg) {
            return !arg.getType().equals("IIOP_CLEAR_TEXT");
        }
    };
    private static ThreadLocal<Boolean> skipRotate = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private <T> List<T> filter(List<T> arg, UnaryPredicate<T> pred) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : arg) {
            if (!pred.evaluate(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    public static void setSkipRotate() {
        skipRotate.set(true);
    }

    @InfoMethod
    private void display(String msg, int value) {
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @Transport
    private synchronized List<ContactInfo> rotate(List<ContactInfo> arg) {
        if (skipRotate.get().booleanValue()) {
            skipRotate.set(false);
            return arg;
        }
        if (this.usePerRequestLoadBalancing) {
            this.display("startCount", this.startCount);
            LinkedList<ContactInfo> tempList = null;
            tempList = new LinkedList<ContactInfo>(this.filter(arg, this.testPred));
            if (this.startCount >= tempList.size()) {
                this.startCount = 0;
            }
            for (int ctr = 0; ctr < this.startCount; ++ctr) {
                ContactInfo element = tempList.removeLast();
                tempList.addFirst(element);
            }
            ++this.startCount;
            return tempList;
        }
        return arg;
    }

    public ContactInfoListImpl(ORB orb) {
        this.orb = orb;
    }

    public ContactInfoListImpl(ORB orb, IOR targetIOR) {
        this(orb);
        this.setTargetIOR(targetIOR);
    }

    @Override
    public synchronized Iterator<ContactInfo> iterator() {
        this.createContactInfoList();
        ContactInfoListIteratorImpl result = new ContactInfoListIteratorImpl(this.orb, this, this.primaryContactInfo, this.rotate(this.effectiveTargetIORContactInfoList), this.usePerRequestLoadBalancing);
        return result;
    }

    @Override
    public synchronized void setTargetIOR(IOR targetIOR) {
        this.targetIOR = targetIOR;
        this.setEffectiveTargetIOR(targetIOR);
    }

    @Override
    public synchronized IOR getTargetIOR() {
        return this.targetIOR;
    }

    private IIOPAddress getPrimaryAddress(IOR ior) {
        if (ior != null) {
            for (TaggedProfile tprof : ior) {
                TaggedProfileTemplate tpt = tprof.getTaggedProfileTemplate();
                if (!(tpt instanceof IIOPProfileTemplate)) continue;
                IIOPProfileTemplate ipt = (IIOPProfileTemplate)tpt;
                return ipt.getPrimaryAddress();
            }
        }
        return null;
    }

    @InfoMethod
    private void changingEffectiveAddress(IIOPAddress oldAddr, IIOPAddress newAddr) {
    }

    @Override
    @Transport
    public synchronized void setEffectiveTargetIOR(IOR newIOR) {
        if (this.targetIOR != null) {
            String oldTypeId = this.targetIOR.getTypeId();
            String newTypeId = newIOR.getTypeId();
            if (!oldTypeId.isEmpty() && !oldTypeId.equals(newTypeId)) {
                wrapper.changedTypeIdOnSetEffectiveTargetIOR(oldTypeId, newTypeId);
                return;
            }
        }
        IIOPAddress oldAddress = this.getPrimaryAddress(this.effectiveTargetIOR);
        IIOPAddress newAddress = this.getPrimaryAddress(newIOR);
        if (oldAddress != null && !oldAddress.equals(newAddress)) {
            this.changingEffectiveAddress(oldAddress, newAddress);
        }
        this.effectiveTargetIOR = newIOR;
        this.effectiveTargetIORContactInfoList = null;
        if (this.primaryContactInfo != null && this.orb.getORBData().getIIOPPrimaryToContactInfo() != null) {
            this.orb.getORBData().getIIOPPrimaryToContactInfo().reset(this.primaryContactInfo);
        }
        this.primaryContactInfo = null;
        this.setLocalSubcontract();
        IIOPProfile prof = newIOR.getProfile();
        TaggedProfileTemplate temp = prof.getTaggedProfileTemplate();
        Iterator<TaggedComponent> lbcomps = temp.iteratorById(1398099461);
        if (lbcomps.hasNext()) {
            LoadBalancingComponent lbcomp = null;
            lbcomp = (LoadBalancingComponent)lbcomps.next();
            this.usePerRequestLoadBalancing = lbcomp.getLoadBalancingValue() == 1;
        }
    }

    @Override
    public synchronized IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    @Override
    public synchronized LocalClientRequestDispatcher getLocalClientRequestDispatcher() {
        this.lcrdLock.readLock().lock();
        try {
            LocalClientRequestDispatcher localClientRequestDispatcher = this.localClientRequestDispatcher;
            return localClientRequestDispatcher;
        }
        finally {
            this.lcrdLock.readLock().unlock();
        }
    }

    @Override
    public synchronized int hashCode() {
        return this.targetIOR.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactInfoListImpl other = (ContactInfoListImpl)obj;
        return this.targetIOR == other.targetIOR || this.targetIOR != null && this.targetIOR.equals(other.targetIOR);
    }

    @Transport
    private void createContactInfoList() {
        IIOPProfile iiopProfile = this.effectiveTargetIOR.getProfile();
        boolean isLocal = iiopProfile.isLocal();
        if (this.effectiveTargetIORContactInfoList == null) {
            this.effectiveTargetIORContactInfoList = new ArrayList<ContactInfo>();
            IIOPProfileTemplate taggedProfileTemplate = (IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate();
            SocketInfo socketInfo = taggedProfileTemplate.getPrimarySocketInfo();
            this.primaryContactInfo = this.createContactInfo(socketInfo.getType(), socketInfo.getHost(), socketInfo.getPort());
            if (isLocal) {
                SharedCDRContactInfoImpl contactInfo = new SharedCDRContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition());
                this.effectiveTargetIORContactInfoList.add(contactInfo);
            } else {
                this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
            }
            this.display("First time for iiopProfile", iiopProfile);
        } else if (!isLocal) {
            this.display("Subsequent time for iiopProfile", iiopProfile);
            this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
        } else {
            this.display("Subsequent time for (colocated) iiopProfile", iiopProfile);
        }
        this.display("effective list", this.effectiveTargetIORContactInfoList);
    }

    @Transport
    private void addRemoteContactInfos(IOR effectiveTargetIOR, List<ContactInfo> effectiveTargetIORContactInfoList) {
        List<? extends SocketInfo> socketInfos = this.orb.getORBData().getIORToSocketInfo().getSocketInfo(effectiveTargetIOR, effectiveTargetIORContactInfoList);
        if (socketInfos == effectiveTargetIORContactInfoList) {
            this.display("socketInfos", socketInfos);
            return;
        }
        for (SocketInfo socketInfo : socketInfos) {
            String type = socketInfo.getType();
            String host = socketInfo.getHost().toLowerCase();
            int port = socketInfo.getPort();
            ContactInfo contactInfo = this.createContactInfo(type, host, port);
            effectiveTargetIORContactInfoList.add(contactInfo);
        }
    }

    protected ContactInfo createContactInfo(String type, String hostname, int port) {
        return new ContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
    }

    @IsLocal
    protected void setLocalSubcontract() {
        this.lcrdLock.writeLock().lock();
        try {
            if (!this.effectiveTargetIOR.getProfile().isLocal()) {
                this.localClientRequestDispatcher = new NotLocalLocalCRDImpl();
                return;
            }
            int scid = this.effectiveTargetIOR.getProfile().getObjectKeyTemplate().getSubcontractId();
            LocalClientRequestDispatcherFactory lcsf = this.orb.getRequestDispatcherRegistry().getLocalClientRequestDispatcherFactory(scid);
            if (lcsf != null) {
                this.localClientRequestDispatcher = lcsf.create(scid, this.effectiveTargetIOR);
            }
        }
        finally {
            this.lcrdLock.writeLock().unlock();
        }
    }

    public ContactInfo getPrimaryContactInfo() {
        return this.primaryContactInfo;
    }
}

