/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.util;

import jakarta.mvc.Controller;
import jakarta.ws.rs.HttpMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.krazo.util.AnnotationUtils;

public final class ControllerUtils {
    private ControllerUtils() {
    }

    public static boolean isController(Class<?> clazz) {
        return AnnotationUtils.getAnnotation(clazz, Controller.class) != null || Arrays.stream(clazz.getMethods()).anyMatch(m -> AnnotationUtils.getAnnotation(m, Controller.class) != null);
    }

    public static boolean isControllerMethod(Method method) {
        boolean isController = AnnotationUtils.getAnnotation(method.getDeclaringClass(), Controller.class) != null || AnnotationUtils.getAnnotation(method, Controller.class) != null;
        return isController && ControllerUtils.isRequestMethod(method);
    }

    static boolean isRequestMethod(Method method) {
        if (ControllerUtils.hasDeclaredRequestMethodAnnotation(method)) {
            return true;
        }
        if (AnnotationUtils.hasJaxrsAnnotations(method)) {
            return false;
        }
        for (Class<?> clazz = method.getDeclaringClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method currentMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                if (!ControllerUtils.hasDeclaredRequestMethodAnnotation(currentMethod)) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Class<?> in : method.getDeclaringClass().getInterfaces()) {
            try {
                Method currentMethod = in.getMethod(method.getName(), method.getParameterTypes());
                if (!ControllerUtils.hasDeclaredRequestMethodAnnotation(currentMethod)) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean hasDeclaredRequestMethodAnnotation(Method method) {
        return Arrays.stream(method.getDeclaredAnnotations()).anyMatch(anno -> anno.annotationType().getAnnotation(HttpMethod.class) != null);
    }
}

