/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.language;

import com.sun.ts.tests.el.common.spec.Book;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.ResolverType;
import jakarta.el.ELException;
import java.util.Hashtable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static String NLINE = System.getProperty("line.separator", "\n");

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void poundDollarSameMeaning1Test() throws Exception {
        boolean pass = true;
        String testExpr = "\"foo\"";
        try {
            Object dollarResult = ExprEval.evaluateValueExpression("${" + testExpr + "}", null, String.class);
            Object poundResult = ExprEval.evaluateValueExpression("#{" + testExpr + "}", null, String.class);
            logger.log(System.Logger.Level.TRACE, "Comparing  ${" + dollarResult.toString() + "} to #{" + poundResult.toString() + "}");
            pass = ExprEval.compareClass(poundResult, String.class) && ExprEval.compareClass(dollarResult, String.class) && ExprEval.compareValue(poundResult, dollarResult);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void poundDollarSameMeaning2Test() throws Exception {
        boolean pass = true;
        try {
            Object firstNameDollar = ExprEval.evaluateValueExpression("${worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            Object firstNamePound = ExprEval.evaluateValueExpression("#{worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            logger.log(System.Logger.Level.TRACE, "Comparing  ${" + firstNameDollar.toString() + "} to #{" + firstNamePound.toString() + "}");
            if (!firstNamePound.toString().equals(firstNameDollar.toString())) {
                logger.log(System.Logger.Level.TRACE, "Dollar & Pound symbols return differentexpression values!");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void nestedEvalExpressionsTest() throws Exception {
        boolean pass = true;
        String[] expr = new String[]{"${worker[${worker}]}", "${worker[#{worker}]}", "#{worker[${worker}]}", "#{worker[#{worker}]}"};
        for (int i = 0; i < expr.length; ++i) {
            try {
                ExprEval.evaluateValueExpression(expr[i], null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Test FAILED. No exception thrown for ");
                logger.log(System.Logger.Level.ERROR, expr[i]);
                continue;
            }
            catch (ELException ee) {
                logger.log(System.Logger.Level.ERROR, "Expected Exception thrown.");
                continue;
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Test FAILED. " + expr[i] + " caused ");
                logger.log(System.Logger.Level.ERROR, "an exception, but it was not an ");
                logger.log(System.Logger.Level.ERROR, "ELException.");
                ELTestUtil.printStackTrace(e);
            }
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void mixedCompositeExpressionsTest() throws Exception {
        boolean pass = true;
        String[] expr = new String[]{"${worker}#{worker}", "#{worker}${worker}", "${worker}#{worker}${worker}", "#{worker}${worker}#{worker}"};
        for (int i = 0; i < expr.length; ++i) {
            try {
                ExprEval.evaluateValueExpression(expr[i], null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Test FAILED. No exception thrown for ");
                logger.log(System.Logger.Level.ERROR, expr[i]);
            }
            catch (ELException ee) {
                logger.log(System.Logger.Level.ERROR, "Expected Exception thrown.");
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Test FAILED. " + expr[i] + " caused ");
                logger.log(System.Logger.Level.ERROR, "an exception, but it was not an ");
                logger.log(System.Logger.Level.ERROR, "ELException.");
                ELTestUtil.printStackTrace(e);
            }
            if (pass) continue;
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void compositeExprEval1Test() throws Exception {
        boolean pass = true;
        String streetName = "${'Network Circle'}";
        String city = "${'Santa Clara'}";
        String state = "${'CA'}";
        String expected = "4140 Network Circle, Santa Clara, CA 95054";
        try {
            Object address = ExprEval.evaluateValueExpression("4140 " + streetName + ", " + city + ", " + state + " 95054", null, String.class);
            logger.log(System.Logger.Level.TRACE, "Testing for Address: " + expected);
            pass = ExprEval.compareClass(address, String.class) && ExprEval.compareValue(address, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void compositeExprEval2Test() throws Exception {
        boolean pass = true;
        int num = 2;
        String expected = "total = 3.0";
        try {
            Object div = ExprEval.evaluateValueExpression("total = ${" + num + "+2/" + num + "}", null, String.class);
            logger.log(System.Logger.Level.TRACE, "Testing for: " + expected);
            pass = ExprEval.compareClass(div, String.class) && ExprEval.compareValue(div, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void dotAndIndexOperatorsSameTest() throws Exception {
        boolean pass = true;
        try {
            Object firstnameDot = ExprEval.evaluateValueExpression("${worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            Object firstnameBracket = ExprEval.evaluateValueExpression("${worker['firstName']}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            pass = firstnameDot.equals(firstnameBracket);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void elSyntaxEscapeTest() throws Exception {
        boolean pass = true;
        try {
            Object firstnameDollar = ExprEval.evaluateValueExpression("\\${worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            Object firstnamePound = ExprEval.evaluateValueExpression("\\#{worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            if (!ExprEval.compareValue(firstnameDollar, "${worker.firstName}") || !ExprEval.compareValue(firstnamePound, "#{worker.firstName}")) {
                logger.log(System.Logger.Level.TRACE, "Escape character failed to work.");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void literalExprEval1Test() throws Exception {
        String exprStr;
        boolean pass = true;
        String expected = exprStr = "foo";
        try {
            Object expr = ExprEval.evaluateValueExpression(exprStr, null, String.class);
            pass = ExprEval.compareClass(expr, String.class) && ExprEval.compareValue(expr, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void literalExprEval2Test() throws Exception {
        boolean pass = true;
        String exprStr = "true";
        try {
            Object expr = ExprEval.evaluateValueExpression(exprStr, null, Boolean.class);
            pass = ExprEval.compareClass(expr, Boolean.class) && ExprEval.compareValue(expr, (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            ELTestUtil.printStackTrace(e);
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void literalExprAsMethodExpr1Test() throws Exception {
        boolean pass = true;
        try {
            Object value2;
            Class[] params = new Class[]{};
            Object value1 = ExprEval.evaluateMethodExpression("true", params, String.class, ResolverType.VECT_ELRESOLVER);
            if (!"true".equals(value1)) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Literal Expression, Return String Failed!");
            }
            if (!((Boolean)(value2 = ExprEval.evaluateMethodExpression("true", params, Boolean.class, ResolverType.VECT_ELRESOLVER))).booleanValue()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Literal Expression, Return non-String Failed!");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("Test Failed!");
        }
    }

    @Test
    public void literalExprAsMethodExpr2Test() throws Exception {
        boolean pass = true;
        int testNum = 496;
        try {
            Class[] params = new Class[]{};
            Object value = ExprEval.evaluateMethodExpression("496", params, Integer.class, ResolverType.VECT_ELRESOLVER);
            if (!(value instanceof Integer)) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MethodExpression invocation does not return instance of expected class");
            } else if ((Integer)value != testNum) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected: " + testNum + NLINE + "Received: " + value.toString());
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("Test Failed!");
        }
    }

    @Test
    public void rValueCoercion1Test() throws Exception {
        boolean pass = false;
        String expr = "${foo}";
        String expected = "bar";
        try {
            Object value = ExprEval.evaluateCoerceValueExpression(expr, expected, String.class);
            pass = ExprEval.compareClass(value, String.class) && ExprEval.compareValue(value, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void rValueCoercion2Test() throws Exception {
        boolean pass = false;
        String expr = "${javabook}";
        String expected = "The Java Programming Language";
        try {
            Book jbook = new Book(expected, "Arnold and Gosling", "Addison Wesley", 1996);
            Object value = ExprEval.evaluateCoerceValueExpression(expr, jbook, String.class);
            pass = ExprEval.compareClass(value, String.class) && ExprEval.compareValue(value, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void parseOnceEvalManyTest() throws Exception {
        boolean pass = false;
        String expr = "${foo}";
        String expected = "bar";
        Hashtable contextObjects = new Hashtable();
        contextObjects.put(String.class, "string context");
        contextObjects.put(Integer.class, 1);
        contextObjects.put(Boolean.class, Boolean.TRUE);
        try {
            pass = ExprEval.evaluateManyValueExpression(expr, expected, String.class, contextObjects);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void optimiseStandaloneIdentifier() throws Exception {
        boolean pass = false;
        String expr = "${single}";
        String expected = "OK";
        try {
            pass = expected.equals(ExprEval.evaluateValueExpression(expr, null, String.class, ResolverType.SINGLE_IDENTIFER_ELRESOLVER));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void optimiseStandaloneIdentifierNegative() throws Exception {
        boolean pass = false;
        String expr = "${notSingle.length()}";
        Integer expected = "OK".length();
        try {
            pass = expected.equals(ExprEval.evaluateValueExpression(expr, null, Integer.class, ResolverType.SINGLE_IDENTIFER_ELRESOLVER));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }
}

