/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.transaction;

import ee.jakarta.tck.concurrent.common.transaction.Connections;
import ee.jakarta.tck.concurrent.common.transaction.Counter;
import ee.jakarta.tck.concurrent.common.transaction.WorkInterface;
import jakarta.transaction.UserTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.naming.InitialContext;
import org.junit.jupiter.api.Assertions;

public class TransactedTask
implements WorkInterface {
    private static final long serialVersionUID = 1L;
    private final boolean beginTransaction;
    private final boolean isCommit;
    private final String sqlTemplate;

    public TransactedTask(boolean commitOrRollback, boolean beginTransaction, String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
        this.beginTransaction = beginTransaction;
        this.isCommit = commitOrRollback;
    }

    public TransactedTask(boolean commitOrRollback, String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
        this.beginTransaction = true;
        this.isCommit = commitOrRollback;
    }

    @Override
    public void run() {
        int originCount = Counter.getCount();
        UserTransaction ut = null;
        try {
            if (this.beginTransaction) {
                ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                ut.begin();
            }
            try (Connection conn = Connections.getConnection(false);
                 PreparedStatement pStmt = conn.prepareStatement(this.sqlTemplate);){
                String sTypeDesc = "Type-99";
                int newType = 99;
                pStmt.setInt(1, newType);
                pStmt.setString(2, sTypeDesc);
                pStmt.executeUpdate();
                if (this.beginTransaction && this.isCommit) {
                    ut.commit();
                }
                if (this.beginTransaction && !this.isCommit) {
                    ut.rollback();
                }
                int afterTransacted = Counter.getCount();
                if (this.isCommit) {
                    Assertions.assertEquals((int)(originCount + 1), (int)afterTransacted);
                } else {
                    Assertions.assertEquals((int)originCount, (int)afterTransacted);
                }
            }
            catch (Exception e) {
                try {
                    ut.rollback();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doWork() {
        UserTransaction ut = null;
        try {
            if (this.beginTransaction) {
                ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                ut.begin();
            }
            try (Connection conn = Connections.getConnection(false);
                 PreparedStatement pStmt = conn.prepareStatement(this.sqlTemplate);){
                String sTypeDesc = "Type-98";
                int newType = 98;
                pStmt.setInt(1, newType);
                pStmt.setString(2, sTypeDesc);
                pStmt.executeUpdate();
                if (this.beginTransaction && this.isCommit) {
                    ut.commit();
                }
                if (this.beginTransaction && !this.isCommit) {
                    ut.rollback();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

