/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.dd;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.spec.Platform.dd.DeploymentDescriptorServlet;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.CONTEXT, Common.PACKAGE.CONTEXT_PROVIDERS, Common.PACKAGE.QUALIFIERS})
public class DeploymentDescriptorWebTests
extends TestClient {
    @ArquillianResource(value=DeploymentDescriptorServlet.class)
    private URL baseURL;
    @TestName
    private String testname;

    @Deployment(name="DeploymentDescriptorTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"DeploymentDescriptorTests_web.war")).addPackages(false, new Package[]{DeploymentDescriptorWebTests.class.getPackage()})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()})).addAsWebInfResource(DeploymentDescriptorWebTests.class.getPackage(), "web.xml", "web.xml");
    }

    @Override
    protected String getServletPath() {
        return "DeploymentDescriptorServlet";
    }

    @Assertion(id="GIT:404", strategy="Tests injection of context service defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedContextServiceQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed executor service defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedManagedExecutorSvcQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed scheduled exectuor service defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedManagedScheduledExecutorSvcQualifers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed thread factory defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedManagedThreadFactoryQualifers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:186", strategy="Tests context-service defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesContextService() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:186", strategy="Tests managed-executor defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesManagedExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:186", strategy="Tests managed-scheduled-executor defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesManagedScheduledExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:186", strategy="Tests managed-thread-factory defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesManagedThreadFactory() {
        this.runTest(this.baseURL, this.testname);
    }
}

