/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.IllegalProductException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise.British;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise.ConstructorInjectionCorralBroken;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise.FieldInjectionCorralBroken;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise.Herd;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise.Ranch;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.enterprise.SetterInjectionCorralBroken;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class EnterpriseBeanWithIllegalDependencyTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanWithIllegalDependencyTest.class)).build();
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fab")
    public void testFieldInjectionPointRequiringPassivationCapableDependency() {
        this.verify(FieldInjectionCorralBroken.class, new Annotation[0]);
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fab")
    public void testSetterInjectionPointRequiringPassivationCapableDependency() {
        this.verify(SetterInjectionCorralBroken.class, new Annotation[0]);
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fab")
    public void testConstructorInjectionPointRequiringPassivationCapableDependency() {
        this.verify(ConstructorInjectionCorralBroken.class, new Annotation[0]);
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fab")
    public void testProducerMethodParamInjectionPointRequiringPassivationCapableDependency() {
        this.verify(Herd.class, British.BritishLiteral.INSTANCE);
    }

    private void verify(Class<? extends Ranch> clazz, Annotation ... annotations) {
        try {
            this.getContextualReference(clazz, annotations).ping();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalProductException.class, t));
            return;
        }
        Assert.fail();
    }
}

