/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.metadata.injectionpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.metadata.injectionpoint.Info;
import org.jboss.cdi.tck.tests.event.metadata.injectionpoint.InfoObserver;
import org.jboss.cdi.tck.tests.event.metadata.injectionpoint.Nice;
import org.jboss.cdi.tck.tests.event.metadata.injectionpoint.Notifier;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class EventMetadataInjectionPointTest
extends AbstractTest {
    @Inject
    Notifier notifier;
    @Inject
    InfoObserver infoObserver;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventMetadataInjectionPointTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="aa"), @SpecAssertion(section="event_metadata", id="b")})
    public void testGetBean() {
        Bean<?> lastBean = null;
        this.notifier.fireInfoEvent();
        lastBean = this.infoObserver.getLastBean();
        org.testng.Assert.assertNotNull(lastBean);
        org.testng.Assert.assertEquals((Object)lastBean.getBeanClass(), Notifier.class);
        this.notifier.fireInitializerInfoEvent();
        lastBean = this.infoObserver.getLastBean();
        org.testng.Assert.assertNotNull(lastBean);
        org.testng.Assert.assertEquals((Object)lastBean.getBeanClass(), Notifier.class);
        this.notifier.fireConstructorInfoEvent();
        lastBean = this.infoObserver.getLastBean();
        org.testng.Assert.assertNotNull(lastBean);
        org.testng.Assert.assertEquals((Object)lastBean.getBeanClass(), Notifier.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="dca"), @SpecAssertion(section="event_metadata", id="b")})
    public void testIsTransient() {
        this.notifier.fireInfoEvent();
        org.testng.Assert.assertFalse((boolean)this.infoObserver.isLastIsTransient());
        this.notifier.fireTransientInfoEvent();
        org.testng.Assert.assertTrue((boolean)this.infoObserver.isLastIsTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="ba"), @SpecAssertion(section="event_metadata", id="b")})
    public void testGetType() {
        Type lastType = null;
        Type eventInfoLiteralType = new TypeLiteral<Event<Info>>(){}.getType();
        this.notifier.fireInfoEvent();
        lastType = this.infoObserver.getLastType();
        org.testng.Assert.assertNotNull((Object)lastType);
        org.testng.Assert.assertEquals((Object)lastType, (Object)eventInfoLiteralType);
        this.notifier.fireInitializerInfoEvent();
        lastType = this.infoObserver.getLastType();
        org.testng.Assert.assertNotNull((Object)lastType);
        org.testng.Assert.assertEquals((Object)lastType, (Object)eventInfoLiteralType);
        this.notifier.fireConstructorInfoEvent();
        lastType = this.infoObserver.getLastType();
        org.testng.Assert.assertNotNull((Object)lastType);
        org.testng.Assert.assertEquals((Object)lastType, (Object)eventInfoLiteralType);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="bc"), @SpecAssertion(section="event_metadata", id="b")})
    public void testGetQualifiers() {
        Set<Annotation> lastQualifiers = null;
        this.notifier.fireInfoEvent();
        lastQualifiers = this.infoObserver.getLastQualifiers();
        org.testng.Assert.assertNotNull(lastQualifiers);
        Assert.assertAnnotationSetMatches(lastQualifiers, Default.class);
        this.notifier.fireConstructorInfoEvent();
        lastQualifiers = this.infoObserver.getLastQualifiers();
        org.testng.Assert.assertNotNull(lastQualifiers);
        Assert.assertAnnotationSetMatches(lastQualifiers, Nice.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="ca"), @SpecAssertion(section="injection_point", id="cc"), @SpecAssertion(section="injection_point", id="cb"), @SpecAssertion(section="event_metadata", id="b")})
    public void testGetMember() {
        Member lastMember = null;
        this.notifier.fireInfoEvent();
        lastMember = this.infoObserver.getLastMember();
        org.testng.Assert.assertNotNull((Object)lastMember);
        org.testng.Assert.assertTrue((boolean)(lastMember instanceof Field));
        Field field = (Field)lastMember;
        org.testng.Assert.assertEquals((String)field.getName(), (String)"infoEvent");
        org.testng.Assert.assertEquals(field.getType(), Event.class);
        org.testng.Assert.assertEquals(field.getDeclaringClass(), Notifier.class);
        this.notifier.fireInitializerInfoEvent();
        lastMember = this.infoObserver.getLastMember();
        org.testng.Assert.assertNotNull((Object)lastMember);
        org.testng.Assert.assertTrue((boolean)(lastMember instanceof Method));
        Method method = (Method)lastMember;
        org.testng.Assert.assertEquals((String)method.getName(), (String)"setInitializerInjectionInfoEvent");
        org.testng.Assert.assertEquals((int)method.getParameterTypes().length, (int)1);
        org.testng.Assert.assertEquals(method.getDeclaringClass(), Notifier.class);
        this.notifier.fireConstructorInfoEvent();
        lastMember = this.infoObserver.getLastMember();
        org.testng.Assert.assertNotNull((Object)lastMember);
        org.testng.Assert.assertTrue((boolean)(lastMember instanceof Constructor));
        Constructor constructor = (Constructor)lastMember;
        org.testng.Assert.assertEquals((int)constructor.getParameterTypes().length, (int)1);
        org.testng.Assert.assertEquals(constructor.getDeclaringClass(), Notifier.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="daa"), @SpecAssertion(section="event_metadata", id="b")})
    public void testGetAnnotatedType() {
        Annotated lastAnnotated = null;
        this.notifier.fireInfoEvent();
        lastAnnotated = this.infoObserver.getLastAnnotated();
        org.testng.Assert.assertTrue((boolean)(lastAnnotated instanceof AnnotatedField));
        org.testng.Assert.assertEquals((String)((AnnotatedField)lastAnnotated).getJavaMember().getName(), (String)"infoEvent");
        org.testng.Assert.assertTrue((boolean)lastAnnotated.isAnnotationPresent(Inject.class));
        this.notifier.fireInitializerInfoEvent();
        lastAnnotated = this.infoObserver.getLastAnnotated();
        org.testng.Assert.assertTrue((boolean)(lastAnnotated instanceof AnnotatedParameter));
        org.testng.Assert.assertEquals((int)((AnnotatedParameter)lastAnnotated).getPosition(), (int)0);
        this.notifier.fireConstructorInfoEvent();
        lastAnnotated = this.infoObserver.getLastAnnotated();
        org.testng.Assert.assertTrue((boolean)(lastAnnotated instanceof AnnotatedParameter));
        org.testng.Assert.assertEquals((int)((AnnotatedParameter)lastAnnotated).getPosition(), (int)0);
        org.testng.Assert.assertTrue((boolean)lastAnnotated.isAnnotationPresent(Nice.class));
    }
}

