/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.spi.Contextuals;
import org.jboss.cdi.tck.spi.CreationalContexts;
import org.jboss.cdi.tck.util.BeanLookupUtils;
import org.jboss.cdi.tck.util.DependentInstance;

public abstract class AbstractTest
extends Arquillian {
    @Inject
    protected BeanManager beanManager;

    protected BeanManager getCurrentManager() {
        return this.beanManager;
    }

    protected BeanContainer getCurrentBeanContainer() {
        return this.beanManager;
    }

    protected byte[] passivate(Object instance) throws IOException {
        return this.getCurrentConfiguration().getBeans().passivate(instance);
    }

    protected Object activate(byte[] bytes) throws IOException, ClassNotFoundException {
        return this.getCurrentConfiguration().getBeans().activate(bytes);
    }

    protected void setContextActive(Context context) {
        this.getCurrentConfiguration().getContexts().setActive(context);
    }

    protected void setContextInactive(Context context) {
        this.getCurrentConfiguration().getContexts().setInactive(context);
    }

    protected void destroyContext(Context context) {
        this.getCurrentConfiguration().getContexts().destroyContext(context);
    }

    protected <T> CreationalContexts.Inspectable<T> createInspectableCreationalContext(Contextual<T> contextual) {
        return this.getCurrentConfiguration().getCreationalContexts().create(contextual);
    }

    protected <T> Contextuals.Inspectable<T> createInspectableContextual(T instance, Context context) {
        return this.getCurrentConfiguration().getContextuals().create(instance, context);
    }

    protected Configuration getCurrentConfiguration() {
        return ConfigurationFactory.get();
    }

    protected boolean annotationSetMatches(Set<? extends Annotation> annotations, Class<? extends Annotation> ... requiredAnnotationTypes) {
        HashSet<Class<? extends Annotation>> annotationsTypeSet = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : annotations) {
            annotationsTypeSet.add(annotation.annotationType());
        }
        return this.typeSetMatches(annotationsTypeSet, requiredAnnotationTypes);
    }

    protected boolean annotationSetMatches(Set<? extends Annotation> annotations, Annotation ... requiredAnnotations) {
        ArrayList requiredAnnotationList = new ArrayList();
        return requiredAnnotations.length == annotations.size() && annotations.containsAll(requiredAnnotationList);
    }

    protected boolean rawTypeSetMatches(Set<Type> types, Class<?> ... requiredTypes) {
        HashSet<Type> typesRawSet = new HashSet<Type>();
        for (Type type : types) {
            if (type instanceof Class) {
                typesRawSet.add(type);
                continue;
            }
            if (!(type instanceof ParameterizedType)) continue;
            typesRawSet.add(((ParameterizedType)type).getRawType());
        }
        return this.typeSetMatches(typesRawSet, requiredTypes);
    }

    protected boolean typeSetMatches(Collection<? extends Type> types, Type ... requiredTypes) {
        List<Type> typeList = Arrays.asList(requiredTypes);
        return requiredTypes.length == types.size() && types.containsAll(typeList);
    }

    protected <T> Bean<T> getUniqueBean(Class<T> type, Annotation ... bindings) {
        Set<Bean<T>> beans = this.getBeans(type, bindings);
        return this.resolveUniqueBean(type, beans);
    }

    protected <T> Bean<T> getUniqueBean(TypeLiteral<T> type, Annotation ... bindings) {
        Set<Bean<T>> beans = this.getBeans(type, bindings);
        return this.resolveUniqueBean(type.getType(), beans);
    }

    protected <T> Set<Bean<T>> getBeans(Class<T> type, Annotation ... bindings) {
        return this.getCurrentManager().getBeans(type, bindings);
    }

    protected <T> Set<Bean<T>> getBeans(TypeLiteral<T> type, Annotation ... bindings) {
        return this.getCurrentManager().getBeans(type.getType(), bindings);
    }

    protected <T> T getContextualReference(Class<T> beanType, Annotation ... qualifiers) {
        return BeanLookupUtils.getContextualReference(this.getCurrentManager(), beanType, qualifiers);
    }

    protected <T> T getContextualReference(TypeLiteral<T> beanType, Annotation ... qualifiers) {
        return BeanLookupUtils.getContextualReference(this.getCurrentManager(), beanType, qualifiers);
    }

    protected <T> T getContextualReference(String name, Class<T> beanType) {
        return BeanLookupUtils.getContextualReference(this.getCurrentManager(), name, beanType);
    }

    protected <T> DependentInstance<T> newDependentInstance(Class<T> beanType, Annotation ... qualifiers) {
        return new DependentInstance<T>(this.getCurrentManager(), beanType, qualifiers);
    }

    private <T> Bean<T> resolveUniqueBean(Type type, Set<Bean<T>> beans) {
        if (beans.size() == 0) {
            throw new UnsatisfiedResolutionException("Unable to resolve any beans of " + type);
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException("More than one bean available (" + beans + ")");
        }
        return beans.iterator().next();
    }

    protected boolean isThrowablePresent(Class<? extends Throwable> throwableType, Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwableType.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        return this.isThrowablePresent(throwableType, throwable.getCause());
    }
}

