/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.cdi.tck.impl.ConfigurationFactory;

public class Timer {
    private static final long DEFAULT_SLEEP_INTERVAL = 50L;
    private static final ResolutionLogic DEFAULT_RESOLUTION_LOGIC = ResolutionLogic.DISJUNCTION;
    private long delay;
    private long sleepInterval;
    private List<StopCondition> stopConditions = null;
    private ResolutionLogic resolutionLogic;
    private boolean stopConditionsSatisfiedBeforeTimeout;

    public Timer() {
        this.reset();
    }

    public Timer setDelay(long delay) {
        return this.setDelay(delay, TimeUnit.MILLISECONDS);
    }

    public Timer setDelay(long delay, TimeUnit timeUnit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("Delay must be greater than zero");
        }
        this.delay = (timeUnit.toMillis(delay) * (long)ConfigurationFactory.get().getTestTimeoutFactor() - 1L) / 100L + 1L;
        return this;
    }

    public Timer setSleepInterval(long sleepInterval) {
        this.sleepInterval = sleepInterval;
        return this;
    }

    public Timer setResolutionLogic(ResolutionLogic resolutionLogic) {
        this.resolutionLogic = resolutionLogic;
        return this;
    }

    public Timer addStopCondition(StopCondition condition) {
        return this.addStopCondition(condition, false);
    }

    public Timer addStopCondition(StopCondition condition, boolean clear) {
        if (condition != null) {
            if (this.stopConditions == null) {
                this.stopConditions = new ArrayList<StopCondition>(5);
            } else if (clear) {
                this.clearStopConditions();
            }
            this.stopConditions.add(condition);
        }
        return this;
    }

    public Timer start() throws InterruptedException {
        this.checkConfiguration();
        if (this.stopConditions == null || this.stopConditions.isEmpty()) {
            Thread.sleep(this.delay);
        } else {
            long start = System.currentTimeMillis();
            while (this.resolveSleepConditions(start)) {
                Thread.sleep(this.sleepInterval);
            }
        }
        return this;
    }

    public void reset() {
        this.delay = -1L;
        this.sleepInterval = 50L;
        this.resolutionLogic = DEFAULT_RESOLUTION_LOGIC;
        this.clearStopConditions();
    }

    public void clearStopConditions() {
        if (this.stopConditions != null) {
            this.stopConditions.clear();
        }
        this.stopConditionsSatisfiedBeforeTimeout = false;
    }

    public boolean isStopConditionsSatisfiedBeforeTimeout() {
        return this.stopConditionsSatisfiedBeforeTimeout;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getSleepInterval() {
        return this.sleepInterval;
    }

    public static Timer startNew(long delay) throws InterruptedException {
        return new Timer().setDelay(delay).start();
    }

    public static Timer startNew(long delay, long sleepInterval) throws InterruptedException {
        return new Timer().setDelay(delay).setSleepInterval(sleepInterval).start();
    }

    private boolean resolveSleepConditions(long start) {
        if (this.hasConditionsSatisfied()) {
            this.stopConditionsSatisfiedBeforeTimeout = true;
            return false;
        }
        return !this.isTimeoutExpired(start);
    }

    private void checkConfiguration() {
        if (this.delay < 0L || this.sleepInterval < 0L || this.delay < this.sleepInterval) {
            throw new IllegalStateException("Invalid timer configuration");
        }
    }

    private boolean hasConditionsSatisfied() {
        switch (this.resolutionLogic) {
            case DISJUNCTION: {
                return this.hasAtLeastOneConditionsSatisfied();
            }
            case CONJUNCTION: {
                return this.hasAllConditionsSatisfied();
            }
        }
        throw new IllegalStateException("Unsupported condition resolution logic");
    }

    private boolean hasAtLeastOneConditionsSatisfied() {
        for (StopCondition condition : this.stopConditions) {
            if (!condition.isSatisfied()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAllConditionsSatisfied() {
        for (StopCondition condition : this.stopConditions) {
            if (condition.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    private boolean isTimeoutExpired(long start) {
        return System.currentTimeMillis() - start >= this.delay;
    }

    public static enum ResolutionLogic {
        DISJUNCTION,
        CONJUNCTION;

    }

    public static interface StopCondition {
        public boolean isSatisfied();
    }
}

