/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.Cockatoo;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.Listener;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.SuperContext;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.Talk;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.TestableObserverMethod;
import org.jboss.cdi.tck.util.SimpleLogger;

public class AfterBeanDiscoveryObserver
implements Extension {
    private static final SimpleLogger logger = new SimpleLogger(AfterBeanDiscoveryObserver.class);
    public static TestableObserverMethod<Talk> addedObserverMethod;
    private AtomicInteger talkPOMObservedCount = new AtomicInteger(0);
    private AtomicInteger talkPSOMObservedCount = new AtomicInteger(0);
    private AtomicInteger cockatooPBObservedCount = new AtomicInteger(0);
    private AtomicInteger cockatooPSBObservedCount = new AtomicInteger(0);

    public void observeProcessSyntheticBean(@Observes ProcessSyntheticBean<Cockatoo> event) {
        this.cockatooPSBObservedCount.incrementAndGet();
        assert (event.getBean().getName().equals("cockatoo"));
    }

    public void observeProcessBean(@Observes ProcessBean<Cockatoo> event) {
        this.cockatooPBObservedCount.incrementAndGet();
    }

    public void observeProcessObserverMethod(@Observes ProcessObserverMethod<Talk, Listener> event) {
        this.talkPOMObservedCount.incrementAndGet();
    }

    public void observeProcessSyntheticObserverMethod(@Observes ProcessSyntheticObserverMethod<Talk, Listener> event) {
        this.talkPSOMObservedCount.incrementAndGet();
    }

    public void addABean(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.addBean(event, beanManager);
        this.addObserverMethod(event);
        event.addContext((Context)new SuperContext());
    }

    private void addBean(AfterBeanDiscovery event, final BeanManager beanManager) {
        event.addBean((Bean)new Bean<Cockatoo>(){
            private final Set<Annotation> qualifiers = new HashSet<Default.Literal>(Arrays.asList(Default.Literal.INSTANCE));
            private final Set<Type> types = new HashSet<Type>(Arrays.asList(Cockatoo.class));

            public Class<?> getBeanClass() {
                return Cockatoo.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public String getName() {
                return "cockatoo";
            }

            public Set<Annotation> getQualifiers() {
                return this.qualifiers;
            }

            public Class<? extends Annotation> getScope() {
                return Dependent.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return this.types;
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return true;
            }

            public Cockatoo create(CreationalContext<Cockatoo> creationalContext) {
                Cockatoo cockatoo = new Cockatoo("Billy");
                try {
                    Object injectionPoint;
                    AnnotatedType annotatedType = beanManager.createAnnotatedType(Cockatoo.class);
                    AnnotatedField injectionPointField = null;
                    for (AnnotatedField field : annotatedType.getFields()) {
                        if (!field.getBaseType().equals(InjectionPoint.class)) continue;
                        injectionPointField = field;
                    }
                    if (injectionPointField != null && (injectionPoint = beanManager.getInjectableReference(beanManager.createInjectionPoint(injectionPointField), creationalContext)) != null) {
                        cockatoo.setInjectionPoint((InjectionPoint)injectionPoint);
                    }
                }
                catch (Exception e) {
                    logger.log("InjectionPoint is not available: {0}", e.getMessage());
                }
                return cockatoo;
            }

            public void destroy(Cockatoo instance, CreationalContext<Cockatoo> creationalContext) {
            }
        });
    }

    private void addObserverMethod(AfterBeanDiscovery event) {
        addedObserverMethod = new TestableObserverMethod<Talk>(){
            boolean observed = false;

            public void notify(Talk event) {
                this.observed = true;
            }

            public void notify(Talk event, Set<Annotation> qualifiers) {
                this.observed = true;
            }

            @Override
            public boolean isObserved() {
                return this.observed;
            }

            public Class<?> getBeanClass() {
                return Listener.class;
            }

            public Set<Annotation> getObservedQualifiers() {
                return Collections.singleton(Any.Literal.INSTANCE);
            }

            public Type getObservedType() {
                return Talk.class;
            }

            public Reception getReception() {
                return Reception.ALWAYS;
            }

            public TransactionPhase getTransactionPhase() {
                return TransactionPhase.IN_PROGRESS;
            }
        };
        event.addObserverMethod(addedObserverMethod);
    }

    public AtomicInteger getTalkPOMObservedCount() {
        return this.talkPOMObservedCount;
    }

    public AtomicInteger getTalkPSOMObservedCount() {
        return this.talkPSOMObservedCount;
    }

    public AtomicInteger getCockatooPBObservedCount() {
        return this.cockatooPBObservedCount;
    }

    public AtomicInteger getCockatooPSBObservedCount() {
        return this.cockatooPSBObservedCount;
    }
}

