/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.jms;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.TextMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cdi.tck.tests.context.request.event.jms.RequestScopedObserver;

public class AbstractMessageListener
implements MessageListener {
    private static AtomicInteger processedMessages = new AtomicInteger(0);
    private static AtomicBoolean initializedEventObserver = new AtomicBoolean();
    private static AtomicBoolean initialized = new AtomicBoolean();
    @Inject
    private RequestScopedObserver observer;

    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Unsupported message type");
        }
        processedMessages.incrementAndGet();
        initializedEventObserver.set(this.observer.isInitializedObserved());
    }

    public static void reset() {
        processedMessages.set(0);
        initializedEventObserver.set(false);
    }

    public static int getProcessedMessages() {
        return processedMessages.get();
    }

    public static boolean isInitializedEventObserver() {
        return initializedEventObserver.get();
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    @PostConstruct
    public void postConstruct() {
        initialized.set(true);
    }
}

