/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.qualifier;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.qualifier.Barn;
import org.jboss.cdi.tck.tests.definition.qualifier.BorderCollie;
import org.jboss.cdi.tck.tests.definition.qualifier.Cat;
import org.jboss.cdi.tck.tests.definition.qualifier.ChunkyQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.ClippedBorderCollie;
import org.jboss.cdi.tck.tests.definition.qualifier.Cod;
import org.jboss.cdi.tck.tests.definition.qualifier.DefangedTarantula;
import org.jboss.cdi.tck.tests.definition.qualifier.EnglishBorderCollie;
import org.jboss.cdi.tck.tests.definition.qualifier.HairyQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.MiniatureShetlandPony;
import org.jboss.cdi.tck.tests.definition.qualifier.ShetlandPony;
import org.jboss.cdi.tck.tests.definition.qualifier.SynchronousQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.TameLiteral;
import org.jboss.cdi.tck.tests.definition.qualifier.Tarantula;
import org.jboss.cdi.tck.tests.definition.qualifier.WhitefishQualifier;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class QualifierDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(QualifierDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="defining_qualifier_types", id="ba")
    public void testQualifierDeclaresBindingAnnotation() {
        Assert.assertFalse((boolean)this.getBeans(Tarantula.class, new TameLiteral()).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_qualifiers", id="a"), @SpecAssertion(section="declaring_managed_bean", id="be")})
    public void testQualifiersDeclaredInJava() {
        Bean<Cat> cat = this.getBeans(Cat.class, new SynchronousQualifier()).iterator().next();
        assert (cat.getQualifiers().size() == 2);
        assert (cat.getQualifiers().contains(new SynchronousQualifier()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_qualifiers", id="d")})
    public void testMultipleQualifiers() {
        Bean<Cod> model = this.getBeans(Cod.class, new ChunkyQualifier(true), new WhitefishQualifier()).iterator().next();
        assert (model.getQualifiers().size() == 4);
    }

    @SpecAssertion(section="method_constructor_parameter_qualifiers", id="a")
    public void testFieldInjectedFromProducerMethod() throws Exception {
        Bean<Barn> barnBean = this.getBeans(Barn.class, new Annotation[0]).iterator().next();
        Barn barn = (Barn)barnBean.create(this.getCurrentManager().createCreationalContext(barnBean));
        assert (barn.petSpider != null);
        assert (barn.petSpider instanceof DefangedTarantula);
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="aa")
    public void testQualifierDeclaredInheritedIsInherited() throws Exception {
        Set bindings = this.getBeans(BorderCollie.class, new HairyQualifier(false)).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains(new HairyQualifier(false)));
        assert (bindings.contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="aaa")
    public void testQualifierNotDeclaredInheritedIsNotInherited() {
        Set bindings = this.getBeans(ShetlandPony.class, new Annotation[0]).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains(Default.Literal.INSTANCE));
        assert (bindings.contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="aa")
    public void testQualifierDeclaredInheritedIsBlockedByIntermediateClass() {
        Set bindings = this.getBeans(ClippedBorderCollie.class, new HairyQualifier(true)).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        HairyQualifier hairyLiteral = new HairyQualifier(true);
        assert (bindings.contains(hairyLiteral));
        assert (bindings.contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="ag")
    public void testQualifierDeclaredInheritedIsIndirectlyInherited() {
        Set bindings = this.getBeans(EnglishBorderCollie.class, new HairyQualifier(false)).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains(new HairyQualifier(false)));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="aga")
    public void testQualifierNotDeclaredInheritedIsNotIndirectlyInherited() {
        Set bindings = this.getBeans(MiniatureShetlandPony.class, new Annotation[0]).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains(Default.Literal.INSTANCE));
        assert (bindings.contains(Any.Literal.INSTANCE));
    }
}

