/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constructorvalidation;

import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constructorvalidation.Cascaded;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class CascadedValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)CascadedValidationTest.webArchiveBuilder().withTestClass(CascadedValidationTest.class)).withClass(Cascaded.class)).withValidationXml("validation-CascadedValidationTest.xml")).withResource("CascadedValidationTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="n")
    public void testValidaAnnotationIsApplied() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(Cascaded.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Assert.assertTrue((boolean)returnValueDescriptor.isCascaded(), (String)"Cascaded validation should be applied");
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)descriptor.getParameterDescriptors().get(0);
        Assert.assertTrue((boolean)parameterDescriptor.isCascaded(), (String)"Cascaded validation should be applied");
    }
}

