/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.Order;

@Target(value={ElementType.TYPE_USE})
@Constraint(validatedBy={Validator.class})
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RetailOrder {
    public String message() default "not a valid retail order";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<RetailOrder, Order> {
        public boolean isValid(Order order, ConstraintValidatorContext constraintValidatorContext) {
            if (order == null || order.getId() == null) {
                return true;
            }
            return order.getId().startsWith("RETAIL-");
        }
    }
}

