/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import jakarta.validation.ClockProvider;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.FutureOrPresent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.time.ClockProviderPastTest;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.FutureOrPresentDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.FutureOrPresentRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ClockProviderFutureOrPresentTest
extends AbstractTCKTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ClockProviderFutureOrPresentTest.webArchiveBuilder().withTestClassPackage(ClockProviderPastTest.class)).build();
    }

    @Test
    @SpecAssertion(section="builtinconstraints-futureorpresent", id="a")
    public void clockProviderIsUsed() {
        FutureOrPresentDummyEntity dummy = new FutureOrPresentDummyEntity(ZonedDateTime.of(2099, 1, 12, 5, 0, 0, 0, TZ_BERLIN));
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintViolationAssert.assertNoViolations(validator.validate((Object)dummy, new Class[0]));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2100, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("date"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("instant"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("year"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("zonedDateTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-futureorpresent", id="a")
    public void clockProviderIsUsedForRelativePartials() {
        FutureOrPresentRelativePartialDummyEntity dummy = new FutureOrPresentRelativePartialDummyEntity(ZonedDateTime.of(2016, 6, 6, 14, 45, 0, 0, TZ_BERLIN));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2015, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        ConstraintViolationAssert.assertNoViolations(validator.validate((Object)dummy, new Class[0]));
        clockProvider = new FixedClockProvider(ZonedDateTime.of(2016, 8, 17, 17, 45, 0, 0, TZ_BERLIN));
        validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("offsetTime"));
    }
}

