/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.cdo.migration.execution;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.cdo.migration.execution.CDOPersistency;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.history.reconstruction.FinishedException;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.MigrationReconstructor;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMigrationReconstructor
extends MigrationReconstructor {
    public CDOMigrationReconstructor(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor, IClassLoader classLoader, ValidationLevel level, IResourceSetFactory resourceSetFactory) {
        super(modelURIs, sourceRelease, targetRelease, monitor, classLoader, level, resourceSetFactory);
    }

    protected void loadRepository() {
        Metamodel metamodel = this.loadMetamodel();
        metamodel.refreshCaches();
        try {
            ResourceSet set = this.resourceSetFactory.createResourceSet();
            Model model = CDOPersistency.loadModel(this.modelURIs, metamodel, set);
            this.repository = MigrationFactory.eINSTANCE.createRepository();
            this.repository.setMetamodel(metamodel);
            this.repository.setModel(model);
            this.checkConformanceIfMoreThan(ValidationLevel.HISTORY);
        }
        catch (IOException e) {
            this.throwWrappedMigrationException("Model could not be loaded", e);
        }
    }

    public void endRelease(Release originalRelease) {
        if (originalRelease == this.targetRelease) {
            this.disable();
            this.checkConformanceIfMoreThan(ValidationLevel.HISTORY);
            throw new FinishedException();
        }
        if (originalRelease == this.sourceRelease) {
            this.enable();
            this.start();
            this.loadRepository();
        } else if (this.isEnabled()) {
            this.checkConformanceIfMoreThan(ValidationLevel.RELEASE);
        }
    }
}

