/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.internal.migration.BackwardConverter;
import org.eclipse.emf.edapt.internal.migration.FactoryHelper;
import org.eclipse.emf.edapt.internal.migration.ForwardConverter;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.MetamodelResource;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistency {
    public static Metamodel loadMetamodel(URI metamodelURI) throws IOException {
        ResourceSet resourceSet = ResourceUtils.loadResourceSet((URI)metamodelURI);
        return Persistency.loadMetamodel(resourceSet);
    }

    public static Metamodel loadMetamodel(ResourceSet resourceSet) {
        ResourceUtils.resolveAll((ResourceSet)resourceSet);
        Metamodel metamodel = MigrationFactory.eINSTANCE.createMetamodel();
        for (Resource resource : resourceSet.getResources()) {
            MetamodelResource metamodelResource = MigrationFactory.eINSTANCE.createMetamodelResource();
            metamodelResource.setUri(resource.getURI());
            metamodel.getResources().add((Object)metamodelResource);
            for (EObject element : resource.getContents()) {
                if (!(element instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)element;
                FactoryHelper.INSTANCE.overrideFactory(ePackage);
                metamodelResource.getRootPackages().add((Object)ePackage);
            }
        }
        return metamodel;
    }

    public static Metamodel loadMetamodel(String fileName) throws IOException {
        return Persistency.loadMetamodel(URI.createFileURI((String)fileName));
    }

    public static void saveMetamodel(Metamodel metamodel) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        for (MetamodelResource metamodelResource : metamodel.getResources()) {
            Resource resource = resourceSet.createResource(metamodelResource.getUri());
            resource.getContents().addAll(metamodelResource.getRootPackages());
        }
        ResourceUtils.saveResourceSet((ResourceSet)resourceSet);
    }

    public static Model loadModel(URI modelURI, URI metamodelURI, IResourceSetFactory resourceSetFactory) throws IOException {
        Metamodel metamodel = Persistency.loadMetamodel(metamodelURI);
        Model model = Persistency.loadModel(modelURI, metamodel, resourceSetFactory);
        return model;
    }

    public static Model loadModel(URI modelURI, Metamodel metamodel, IResourceSetFactory resourceSetFactory) throws IOException {
        return Persistency.loadModel(Collections.singletonList(modelURI), metamodel, resourceSetFactory);
    }

    public static Model loadModel(List<URI> modelURIs, Metamodel metamodel, IResourceSetFactory resourceSetFactory) throws IOException {
        ResourceSet resourceSet = ResourceUtils.loadResourceSet(modelURIs, metamodel.getEPackages(), (IResourceSetFactory)resourceSetFactory);
        ForwardConverter fConverter = new ForwardConverter();
        Model model = fConverter.convert(resourceSet);
        model.setMetamodel(metamodel);
        return model;
    }

    public static Model loadModel(String fileName, Metamodel metamodel, IResourceSetFactory resourceSetFactory) throws IOException {
        return Persistency.loadModel(URI.createFileURI((String)fileName), metamodel, resourceSetFactory);
    }

    public static void saveModel(Model model) throws IOException {
        BackwardConverter bConverter = new BackwardConverter();
        ResourceSet resourceSet = bConverter.convert(model);
        ResourceUtils.saveResourceSet((ResourceSet)resourceSet);
    }
}

