/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.nebula.grid;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.graphics.Point;

public final class KeyListenerUtil {
    private KeyListenerUtil() {
    }

    public static void clearSelection(Grid grid, VControl vControl, EMFFormsDatabindingEMF dataBinding) {
        if (grid.getCellSelection().length == 0 || !vControl.isEffectivelyEnabled() || vControl.isEffectivelyReadonly()) {
            return;
        }
        Point[] pointArray = grid.getCellSelection();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point itemCoord = pointArray[n2];
            int column = itemCoord.x;
            int row = itemCoord.y;
            VDomainModelReference dmr = (VDomainModelReference)grid.getColumn(column).getData("domain_model_reference");
            if (!(dmr == null || vControl instanceof VTableControl && TableConfigurationHelper.isReadOnly((VTableControl)((VTableControl)vControl), (VDomainModelReference)dmr))) {
                EObject eObject = (EObject)grid.getItem(row).getData();
                try {
                    KeyListenerUtil.unsetFeature(dataBinding, dmr, eObject);
                }
                catch (DatabindingFailedException databindingFailedException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    static void unsetFeature(EMFFormsDatabindingEMF dataBinding, VDomainModelReference dmr, EObject eObject) throws DatabindingFailedException {
        EStructuralFeature.Setting setting = dataBinding.getSetting(dmr, eObject);
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)setting.getEObject());
        Command command = SetCommand.create((EditingDomain)domain, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature(), (Object)SetCommand.UNSET_VALUE);
        domain.getCommandStack().execute(command);
    }
}

