/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.ConditionServiceManager;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.rule.ConditionService;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class ConditionServiceManagerImpl
implements ConditionServiceManager {
    private final Map<EClass, ConditionService<Condition>> conditionServices = new LinkedHashMap<EClass, ConditionService<Condition>>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeConditionService")
    protected <T extends Condition> void addConditionService(ConditionService<Condition> conditionService) {
        this.conditionServices.put(conditionService.getConditionType(), conditionService);
    }

    protected void removeConditionService(ConditionService<Condition> conditionService) {
        this.conditionServices.remove(conditionService.getConditionType());
    }

    @Override
    public Set<UniqueSetting> getConditionSettings(Condition condition, EObject domainModel) {
        if (condition == null) {
            return Collections.emptySet();
        }
        return this.conditionServices.get(condition.eClass()).getConditionSettings(condition, domainModel);
    }

    @Override
    public boolean evaluate(Condition condition, EObject domainModel) {
        if (condition == null) {
            return false;
        }
        return this.conditionServices.get(condition.eClass()).evaluate(condition, domainModel);
    }

    @Override
    public boolean evaluateChangedValues(Condition condition, EObject domainModel, Map<EStructuralFeature.Setting, Object> possibleNewValues) {
        if (condition == null) {
            return false;
        }
        return this.conditionServices.get(condition.eClass()).evaluateChangedValues(condition, domainModel, possibleNewValues);
    }

    @Override
    public Set<VDomainModelReference> getDomainModelReferences(Condition condition) {
        if (condition == null) {
            return Collections.emptySet();
        }
        return this.conditionServices.get(condition.eClass()).getDomainModelReferences(condition);
    }
}

