/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.wizard;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EEFViewFactory;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.common.interpreter.api.VariableManagerFactory;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.properties.WizardModelOperation;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.SiriusDomainClassTester;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.api.SiriusInterpreter;
import org.eclipse.sirius.properties.core.api.ViewDescriptionConverter;
import org.eclipse.sirius.properties.core.api.WizardModelOperationPreprocessor;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.ui.properties.internal.EditingContextAdapterWrapper;
import org.eclipse.sirius.ui.properties.internal.Messages;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;
import org.eclipse.sirius.ui.properties.internal.wizard.PropertiesWizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WizardTask
extends AbstractOperationTask {
    private Session session;
    private WizardModelOperation wizardModelOperation;

    public WizardTask(CommandContext context, ModelAccessor modelAccessor, IInterpreter interpreter, Session session, WizardModelOperation wizardModelOperation) {
        super(context, modelAccessor, interpreter);
        this.session = session;
        this.wizardModelOperation = wizardModelOperation;
    }

    public String getLabel() {
        return Messages.WizardTask_label;
    }

    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        SiriusInputDescriptor input = new SiriusInputDescriptor((Object)this.context.getCurrentTarget());
        IVariableManager variableManager = new VariableManagerFactory().createVariableManager();
        variableManager.put("self", (Object)input.getSemanticElement());
        variableManager.put("input", (Object)input);
        SiriusInterpreter siriusInterpreter = new SiriusInterpreter(this.session);
        WizardModelOperationPreprocessor preprocessor = new WizardModelOperationPreprocessor(this.wizardModelOperation, (org.eclipse.sirius.common.interpreter.api.IInterpreter)siriusInterpreter, variableManager, new OverridesProvider(this.session));
        Optional optionalWizardModelOperation = preprocessor.convert();
        optionalWizardModelOperation.ifPresent(convertedWizardModelOperation -> {
            Shell shell;
            PropertiesWizardDialog wizardDialog;
            int returnCode;
            EditingContextAdapter editingContextAdapter;
            EditingContextAdapterWrapper editingContextAdapterWrapper;
            EEFViewFactory eefViewFactory = new EEFViewFactory();
            ViewDescriptionConverter viewDescriptionConverter = new ViewDescriptionConverter((List)convertedWizardModelOperation.getPages());
            EEFViewDescription eefViewDescription = viewDescriptionConverter.convert(input);
            EEFView eefView = eefViewFactory.createEEFView(eefViewDescription, variableManager, (org.eclipse.sirius.common.interpreter.api.IInterpreter)siriusInterpreter, (EditingContextAdapter)(editingContextAdapterWrapper = new EditingContextAdapterWrapper(editingContextAdapter = SiriusUIPropertiesPlugin.getPlugin().getEditingContextAdapter(this.session))), (IEEFDomainClassTester)new SiriusDomainClassTester(this.session), (InputDescriptor)input);
            if (!eefView.getPages().isEmpty() && 1 == (returnCode = (wizardDialog = new PropertiesWizardDialog(shell = Display.getCurrent().getActiveShell(), this.extPackage, this.context, this.session, (org.eclipse.sirius.common.interpreter.api.IInterpreter)siriusInterpreter, variableManager, (WizardModelOperation)convertedWizardModelOperation, eefView)).open())) {
                throw new OperationCanceledException();
            }
        });
    }
}

