/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.dialog;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.api.EEFTab;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.properties.DialogButton;
import org.eclipse.sirius.properties.DialogModelOperation;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.ui.properties.internal.EditingContextAdapterWrapper;
import org.eclipse.sirius.ui.properties.internal.dialog.DialogFormContainer;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public class PropertiesFormDialog
extends FormDialog {
    private ModelAccessor modelAccessor;
    private CommandContext context;
    private Session session;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private EEFPage eefPage;
    private DialogModelOperation dialogModelOperation;
    private EEFTab eefTab;
    private Consumer<IStatus> consumer;

    public PropertiesFormDialog(Shell shell, ModelAccessor modelAccessor, CommandContext context, Session session, IInterpreter interpreter, IVariableManager variableManager, DialogModelOperation dialogModelOperation, EEFPage eefPage) {
        super(shell);
        this.modelAccessor = modelAccessor;
        this.context = context;
        this.session = session;
        this.interpreter = interpreter;
        this.variableManager = variableManager;
        this.dialogModelOperation = dialogModelOperation;
        this.eefPage = eefPage;
    }

    protected void createFormContent(IManagedForm managedForm) {
        Optional.ofNullable(this.dialogModelOperation.getTitleExpression()).ifPresent(titleExpression -> {
            IEvaluationResult evaluationResult = this.interpreter.evaluateExpression(this.variableManager.getVariables(), titleExpression);
            if (evaluationResult.getDiagnostic().getSeverity() == 0 && evaluationResult.getValue() instanceof String) {
                String title = (String)evaluationResult.getValue();
                this.getShell().setText(title);
            }
        });
        Optional.ofNullable(this.eefPage.getDescription().getLabelExpression()).ifPresent(labelExpression -> {
            IEvaluationResult evaluationResult = this.interpreter.evaluateExpression(this.variableManager.getVariables(), labelExpression);
            if (evaluationResult.getDiagnostic().getSeverity() == 0 && evaluationResult.getValue() instanceof String) {
                String title = (String)evaluationResult.getValue();
                managedForm.getForm().setText(title);
            }
        });
        managedForm.getMessageManager().setDecorationPosition(16512);
        this.eefTab = new EEFTab(this.eefPage);
        DialogFormContainer container = new DialogFormContainer(this.getShell(), managedForm.getForm().getForm());
        Composite composite = managedForm.getForm().getForm().getBody();
        composite.setLayout((Layout)new FillLayout());
        int style = 768;
        GridData data = new GridData(style);
        composite.setLayoutData((Object)data);
        this.eefTab.createControls(composite, (IEEFFormContainer)container);
        this.eefTab.aboutToBeShown();
        this.eefTab.refresh();
        this.configureModelChangeRefresh();
    }

    private void configureModelChangeRefresh() {
        EditingContextAdapter editingContextAdapter = this.eefPage.getView().getContextAdapter();
        if (editingContextAdapter instanceof EditingContextAdapterWrapper) {
            EditingContextAdapterWrapper wrapper = (EditingContextAdapterWrapper)editingContextAdapter;
            this.consumer = status -> this.refreshDialog();
            wrapper.addPerformedModelChangeConsumer(this.consumer);
        }
    }

    private void refreshDialog() {
        this.eefTab.refresh();
        EList buttons = this.dialogModelOperation.getButtons();
        IntStream.range(0, buttons.size()).forEach(arg_0 -> this.lambda$3((List)buttons, arg_0));
    }

    private void refreshButton(Button button, DialogButton dialogButton) {
        IEvaluationResult evaluationResult;
        String isEnabledExpression = Optional.ofNullable(dialogButton.getIsEnabledExpression()).orElse("");
        if (!isEnabledExpression.isEmpty() && (evaluationResult = this.interpreter.evaluateExpression(this.variableManager.getVariables(), isEnabledExpression)).getDiagnostic().getSeverity() == 0 && evaluationResult.getValue() instanceof Boolean) {
            button.setEnabled(((Boolean)evaluationResult.getValue()).booleanValue());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        EList buttons = this.dialogModelOperation.getButtons();
        if (buttons.size() == 0) {
            super.createButtonsForButtonBar(parent);
        } else {
            IntStream.range(0, buttons.size()).forEach(arg_0 -> this.lambda$4(parent, (List)buttons, arg_0));
            this.refreshDialog();
        }
    }

    private void createButton(Composite parent, DialogButton dialogButton, int index) {
        IEvaluationResult evaluationResult = this.interpreter.evaluateExpression(this.variableManager.getVariables(), dialogButton.getLabelExpression());
        if (evaluationResult.getDiagnostic().getSeverity() == 0 && evaluationResult.getValue() instanceof String) {
            String label = (String)evaluationResult.getValue();
            this.createButton(parent, index, label, dialogButton.isDefault());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (this.dialogModelOperation.getButtons().isEmpty()) {
            super.buttonPressed(buttonId);
        }
        if (this.dialogModelOperation.getButtons().size() > buttonId) {
            DialogButton dialogButton = (DialogButton)this.dialogModelOperation.getButtons().get(buttonId);
            Optional.ofNullable(dialogButton.getInitialOperation()).flatMap(initialOperation -> Optional.ofNullable(initialOperation.getFirstModelOperations())).ifPresent(modelOperation -> {
                ICommandTask task = new TaskHelper(this.modelAccessor, SiriusPlugin.getDefault().getUiCallback()).buildTaskFromModelOperation(this.context.getCurrentTarget(), modelOperation);
                SiriusCommand command = new SiriusCommand(this.session.getTransactionalEditingDomain(), "SiriusToolServices#executeOperation");
                command.getTasks().add(task);
                try {
                    if (command.canExecute()) {
                        command.execute();
                    }
                }
                finally {
                    command.dispose();
                }
            });
            Optional.ofNullable(this.getDialogArea()).ifPresent(Control::setFocus);
            if (dialogButton.isCloseDialogOnClick()) {
                if (dialogButton.isRollbackChangesOnClose()) {
                    this.setReturnCode(1);
                } else {
                    this.setReturnCode(0);
                }
                this.close();
            }
        }
    }

    public boolean close() {
        boolean result = super.close();
        EditingContextAdapter editingContextAdapter = this.eefPage.getView().getContextAdapter();
        if (editingContextAdapter instanceof EditingContextAdapterWrapper) {
            EditingContextAdapterWrapper wrapper = (EditingContextAdapterWrapper)editingContextAdapter;
            wrapper.removePerformedModelChangeConsumer(this.consumer);
        }
        this.eefTab.aboutToBeHidden();
        this.eefTab.dispose();
        return result;
    }

    private /* synthetic */ void lambda$3(List list, int index) {
        this.refreshButton(this.getButton(index), (DialogButton)list.get(index));
    }

    private /* synthetic */ void lambda$4(Composite composite, List list, int index) {
        this.createButton(composite, (DialogButton)list.get(index), index);
    }
}

