/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.delete;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.DeleteFromModelAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.delete.DeleteHookHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramActionBarContributor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteFromModelWithHookAction
extends DeleteFromModelAction {
    public static final int KEY_BINDING = 262212;
    private IWorkbenchPart representationPart;

    public DeleteFromModelWithHookAction(IWorkbenchPart part) {
        super(part);
    }

    public DeleteFromModelWithHookAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public DeleteFromModelWithHookAction(IWorkbenchPage page, IWorkbenchPart part) {
        super(page);
        this.representationPart = part;
    }

    public void init() {
        super.init();
        this.setToolTipText(SiriusDiagramActionBarContributor.DELETE_FROM_MODEL);
        this.setAccelerator(262212);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/deleteModel.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/deleteModel.gif"));
        this.setDisabledImageDescriptor(null);
    }

    public void dispose() {
        super.dispose();
        this.representationPart = null;
    }

    protected Request createTargetRequest() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            DestroyElementRequest destroyRequest = new DestroyElementRequest(editingDomain, false);
            return new EditCommandRequestWrapper((IEditCommandRequest)destroyRequest);
        }
        return super.createTargetRequest();
    }

    private Collection<DSemanticDecorator> computeSelections() {
        LinkedHashSet diagramElements = Sets.newLinkedHashSet();
        List operationSet = this.getOperationSet();
        for (IGraphicalEditPart gEditPart : Iterables.filter((Iterable)operationSet, IGraphicalEditPart.class)) {
            View view = (View)gEditPart.getModel();
            EObject element = ViewUtil.resolveSemanticElement((View)view);
            if (!(element instanceof DSemanticDecorator)) continue;
            diagramElements.add((DSemanticDecorator)element);
        }
        return diagramElements;
    }

    protected boolean calculateEnabled() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (this.representationPart != null && !this.representationPart.equals(part)) {
            return super.isEnabled();
        }
        return this.canExecute();
    }

    private boolean canExecute() {
        List operationSet = this.getOperationSet();
        Iterator editParts = Iterables.filter((Iterable)operationSet, EditPart.class).iterator();
        HashSet potentialDeletion = Sets.newHashSet();
        boolean delete = editParts.hasNext();
        while (editParts.hasNext() && delete) {
            EditPart editPart = (EditPart)editParts.next();
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            if (editPart instanceof TextEditPart || editPart instanceof NoteEditPart || editPart instanceof NoteAttachmentEditPart) {
                delete = false;
                continue;
            }
            IGraphicalEditPart gEditPart = (IGraphicalEditPart)editPart;
            View view = (View)gEditPart.getModel();
            EObject element = ViewUtil.resolveSemanticElement((View)view);
            if (element instanceof DDiagramElement) {
                DDiagramElement dDiagramElement = (DDiagramElement)element;
                if (dDiagramElement.getTarget() == null || dDiagramElement.getTarget().eResource() == null) {
                    return false;
                }
                delete = this.checkDeletionIsAllowed(dDiagramElement);
                if (!delete) continue;
                delete = this.checkDeletionPrecondition(dDiagramElement, !editParts.hasNext(), potentialDeletion);
                continue;
            }
            if (!(element instanceof DRepresentation)) continue;
            delete = false;
        }
        return delete;
    }

    private boolean checkDeletionPrecondition(DDiagramElement dDiagramElement, boolean lastElement, Collection<DDiagramElement> potentialDeletion) {
        boolean delete = true;
        DiagramElementMapping mapping = dDiagramElement.getDiagramElementMapping();
        if (mapping != null) {
            DeleteElementDescription tool = mapping.getDeletionDescription();
            if (tool != null) {
                if (tool.getPrecondition() != null && !StringUtil.isEmpty((String)tool.getPrecondition().trim())) {
                    delete = this.evaluatePrecondition(tool, dDiagramElement);
                }
            } else {
                boolean bl = delete = !dDiagramElement.getSemanticElements().isEmpty() || !lastElement || !potentialDeletion.isEmpty();
            }
        }
        if (delete && !dDiagramElement.getSemanticElements().isEmpty()) {
            potentialDeletion.add(dDiagramElement);
        }
        return delete;
    }

    private boolean checkDeletionIsAllowed(DDiagramElement dDiagramElement) {
        boolean delete = true;
        IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)dDiagramElement);
        if (permissionAuthority != null) {
            if (!permissionAuthority.canEditInstance(dDiagramElement.getTarget()) || !permissionAuthority.canEditInstance((EObject)dDiagramElement)) {
                delete = false;
            } else {
                EObject targetContainer = dDiagramElement.getTarget().eContainer();
                EObject diagramElementContainer = dDiagramElement.getTarget().eContainer();
                if (targetContainer != null && !permissionAuthority.canEditInstance(targetContainer)) {
                    delete = false;
                } else if (diagramElementContainer != null && !permissionAuthority.canEditInstance(diagramElementContainer)) {
                    delete = false;
                }
            }
        }
        return delete;
    }

    private boolean evaluatePrecondition(DeleteElementDescription tool, DDiagramElement dDiagramElement) {
        boolean delete = true;
        EObject semanticContainer = dDiagramElement.getTarget();
        EObject viewContainer = dDiagramElement.eContainer();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)dDiagramElement);
        interpreter.setVariable("containerView", (Object)viewContainer);
        interpreter.setVariable("view", (Object)dDiagramElement);
        interpreter.setVariable("element", (Object)semanticContainer);
        try {
            delete = interpreter.evaluateBoolean(semanticContainer, tool.getPrecondition());
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)tool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
        }
        interpreter.unSetVariable("containerView");
        interpreter.unSetVariable("view");
        interpreter.unSetVariable("element");
        return delete;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        this.setTargetRequest(null);
        Command command = this.getCommand();
        boolean granted = true;
        DeleteHookHelper deleteHookHelper = new DeleteHookHelper(this.computeSelections());
        if (command != null && command.canExecute()) {
            granted = deleteHookHelper.checkDeleteHook();
        }
        if (granted) {
            if (command instanceof CompoundCommand && ((CompoundCommand)command).getChildren().length > 0) {
                CompositeTransactionalCommand compositeModelActionCommand = new CompositeTransactionalCommand(this.getEditingDomain(), this.getCommandLabel());
                CompoundCommand compoundCommand = (CompoundCommand)command;
                Iterator iterator = compoundCommand.getCommands().iterator();
                while (iterator.hasNext()) {
                    compositeModelActionCommand.compose((IUndoableOperation)new CommandProxy((Command)iterator.next()));
                }
                command = new ICommandProxy((ICommand)compositeModelActionCommand);
            }
            if (command != null) {
                this.execute(command, progressMonitor);
            }
        }
    }
}

