/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.filters.diagramfilters.IDiagramFilter;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.extension.FilteredDiagramTypeExtension;
import org.eclipse.emf.ecoretools.filters.internal.extension.FilteredDiagramTypeExtensionManager;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramFilterUtil {
    public static String DIAGRAM_FILTER_STRING_DELIMITER = ";";

    public static List<String> getAllPossibleFilteredType(Diagram diagram) {
        if (diagram == null) {
            return Collections.emptyList();
        }
        FilteredDiagramTypeExtension filteredDiagramTypeExtension = FilteredDiagramTypeExtensionManager.getInstance().getFilteredDiagramTypeExtension(diagram.getType());
        if (filteredDiagramTypeExtension == null) {
            return Collections.emptyList();
        }
        IDiagramFilter diagramFilter = filteredDiagramTypeExtension.getDiagramFilter();
        if (diagramFilter == null) {
            return Collections.emptyList();
        }
        ArrayList<String> keyEntries = new ArrayList<String>();
        for (String key : diagramFilter.getFilteredTypeDescription().keySet()) {
            StringTokenizer stringTokenizer = new StringTokenizer(key, DIAGRAM_FILTER_STRING_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                keyEntries.add(stringTokenizer.nextToken());
            }
        }
        return keyEntries;
    }

    public static List<String> getCurrentFilteredTypeConfiguration(Diagram diagram) {
        if (diagram == null) {
            return Collections.emptyList();
        }
        FilteredDiagramTypeExtension filteredDiagramTypeExtension = FilteredDiagramTypeExtensionManager.getInstance().getFilteredDiagramTypeExtension(diagram.getType());
        if (filteredDiagramTypeExtension == null) {
            return Collections.emptyList();
        }
        IDiagramFilter diagramFilter = filteredDiagramTypeExtension.getDiagramFilter();
        if (diagramFilter == null) {
            return Collections.emptyList();
        }
        return diagramFilter.getCurrentFilteredTypeConfiguration();
    }

    public static Image getDiagramElementImage(Diagram diagram, String element) {
        return FilterPlugin.getInstance().getImage("obj16/diagramelement_obj.gif");
    }

    public static String getDiagramElementName(Diagram diagram, String element) {
        if (!DiagramFilterUtil.getDiagramFilteredTypeDescription(diagram).isEmpty()) {
            return DiagramFilterUtil.getDiagramFilteredTypeDescription(diagram).get(element);
        }
        return "???";
    }

    public static Map<String, String> getDiagramFilteredTypeDescription(Diagram diagram) {
        if (diagram == null) {
            return Collections.emptyMap();
        }
        FilteredDiagramTypeExtension filteredDiagramTypeExtension = FilteredDiagramTypeExtensionManager.getInstance().getFilteredDiagramTypeExtension(diagram.getType());
        if (filteredDiagramTypeExtension == null) {
            return Collections.emptyMap();
        }
        IDiagramFilter diagramFilter = filteredDiagramTypeExtension.getDiagramFilter();
        if (diagramFilter == null) {
            return Collections.emptyMap();
        }
        return diagramFilter.getFilteredTypeDescription();
    }

    public static boolean isDiagramFiltered(Diagram diagramToFilter) {
        List<String> allTypes = DiagramFilterUtil.getAllPossibleFilteredType(diagramToFilter);
        TreeIterator it = diagramToFilter.eAllContents();
        while (it.hasNext()) {
            EObject currentDiagramElement = (EObject)it.next();
            if (!(currentDiagramElement instanceof View) || !DiagramFilterUtil.isFilteredType((View)currentDiagramElement, allTypes) || ((View)currentDiagramElement).isVisible()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFilteredType(View view, List<String> typesToFilter) {
        return typesToFilter.contains(view.getType());
    }

    public static boolean isInKey(String key, List<String> savedConfiguration) {
        ArrayList<String> keyEntries = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(key, DIAGRAM_FILTER_STRING_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            keyEntries.add(stringTokenizer.nextToken());
        }
        for (String innerKey : keyEntries) {
            if (!savedConfiguration.contains(innerKey)) continue;
            return true;
        }
        return false;
    }

    public static void setCurrentFilteredTypeConfiguration(Diagram diagram, List<String> result) {
        if (diagram == null) {
            return;
        }
        FilteredDiagramTypeExtension autosarFilteredDiagramTypeExtension = FilteredDiagramTypeExtensionManager.getInstance().getFilteredDiagramTypeExtension(diagram.getType());
        if (autosarFilteredDiagramTypeExtension == null) {
            return;
        }
        IDiagramFilter diagramFilter = autosarFilteredDiagramTypeExtension.getDiagramFilter();
        if (diagramFilter == null) {
            return;
        }
        diagramFilter.setCurrentFilteredTypeConfiguration(result);
    }

    public static boolean isFilteredSemantic(View view, List<EObject> typesToFilter) {
        if (view == null) {
            return false;
        }
        return typesToFilter.contains(view.getElement());
    }
}

