/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramContentInitializer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;

public class InitializeAndLayoutDiagramCommand
extends AbstractTransactionalCommand {
    private Diagram diagram;
    private boolean initEPackageContent;

    public InitializeAndLayoutDiagramCommand(TransactionalEditingDomain domain, Diagram diagram, boolean initEPackageContent) {
        super(domain, Messages.CommandName_InitializeAndLayoutDiagram, null);
        this.diagram = diagram;
        this.initEPackageContent = initEPackageContent;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.diagram == null) {
            return CommandResult.newWarningCommandResult((String)Messages.InitializeAndLayoutDiagramCommand_UnableToProceed, null);
        }
        EcoreDiagramContentInitializer initializer = new EcoreDiagramContentInitializer();
        initializer.setInitEPackageContent(this.initEPackageContent);
        initializer.initDiagramContent(this.diagram);
        if (!this.diagram.getChildren().isEmpty()) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object view : this.diagram.getChildren()) {
                if (!(view instanceof Node)) continue;
                nodes.add((Node)view);
            }
            LayoutService.getInstance().layoutNodes(nodes, true, "DEFAULT");
        }
        return CommandResult.newOKCommandResult();
    }
}

