/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.py4j.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineCancellationException;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.lang.python.debugger.IPythonScriptRegistry;
import org.eclipse.ease.lang.python.debugger.PythonBreakpoint;
import org.eclipse.ease.lang.python.debugger.PythonDebugger;
import org.eclipse.ease.lang.python.py4j.internal.ICodeTraceFilter;

public class Py4jDebugger
extends PythonDebugger {
    private ICodeTraceFilter fTraceFilter;

    public Py4jDebugger(IDebugEngine engine, boolean showDynamicCode) {
        super(engine, showDynamicCode);
    }

    public void setTraceFilter(ICodeTraceFilter traceFilter) {
        this.fTraceFilter = traceFilter;
    }

    public List<PythonBreakpoint> getBreakpoints(String filename) {
        List breakpoints;
        Script script;
        IPythonScriptRegistry registry = this.getScriptRegistry();
        if (registry != null && (script = registry.getScript(filename)) != null && (breakpoints = (List)this.fBreakpoints.get(script)) != null) {
            ArrayList<PythonBreakpoint> pythonBreakpoints = new ArrayList<PythonBreakpoint>();
            for (IBreakpoint breakpoint : breakpoints) {
                int lineno = breakpoint.getMarker().getAttribute("lineNumber", -1);
                pythonBreakpoints.add(new PythonBreakpoint(filename, lineno));
            }
            return pythonBreakpoints;
        }
        return Collections.emptyList();
    }

    protected void suspend(IDebuggerEvent event) {
        this.fTraceFilter.suspend();
        super.suspend(event);
    }

    protected void resume(int resumeType, Object thread) {
        super.resume(resumeType, thread);
        this.fTraceFilter.resume(resumeType);
    }

    public Object execute(Script script) {
        try {
            String reference = script.getTitle();
            IPythonScriptRegistry registry = this.getScriptRegistry();
            if (registry != null) {
                registry.put(script);
                reference = registry.getReference(script);
            }
            return this.fTraceFilter.run(script, reference);
        }
        catch (Exception e) {
            if (this.getThreadState((Object)this.getThread()).fResumeType == 8) {
                throw new ScriptEngineCancellationException();
            }
            throw e;
        }
    }

    protected void breakpointAdded(Script script, IBreakpoint breakpoint) {
        int linenumber;
        IPythonScriptRegistry registry = this.getScriptRegistry();
        if (registry == null) {
            return;
        }
        String reference = registry.getReference(script);
        if (reference != null && (linenumber = breakpoint.getMarker().getAttribute("lineNumber", -1)) != -1) {
            this.fTraceFilter.setBreakpoint(new PythonBreakpoint(reference, linenumber));
        }
    }

    protected void breakpointRemoved(Script script, IBreakpoint breakpoint) {
        int linenumber;
        IPythonScriptRegistry registry = this.getScriptRegistry();
        if (registry == null) {
            return;
        }
        String reference = registry.getReference(script);
        if (reference != null && (linenumber = breakpoint.getMarker().getAttribute("lineNumber", -1)) != -1) {
            this.fTraceFilter.removeBreakpoint(new PythonBreakpoint(reference, linenumber));
        }
    }
}

