/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.tools;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class PlatformExtension {
    private final IConfigurationElement fConfigurationElement;

    public static Collection<PlatformExtension> createFor(String extensionPoint) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        return Arrays.asList(config).stream().map(e -> new PlatformExtension((IConfigurationElement)e)).collect(Collectors.toSet());
    }

    public static Collection<PlatformExtension> createForName(String extensionPoint, String name) {
        Collection<PlatformExtension> extensions = PlatformExtension.createFor(extensionPoint);
        return extensions.stream().filter(e -> Objects.equals(name, e.getConfigurationElement().getName())).collect(Collectors.toSet());
    }

    public PlatformExtension(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    public <T> T createInstance(String name, Class<T> clazz) throws CoreException {
        Object instance = this.getConfigurationElement().createExecutableExtension(name);
        if (clazz.isAssignableFrom(instance.getClass())) {
            return (T)instance;
        }
        throw new ClassCastException(String.format("Could not cast class '%s' to '%s'", instance.getClass().getName(), clazz.getName()));
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    public String getAttribute(String name) {
        return this.getConfigurationElement().getAttribute(name);
    }
}

