/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.events.model.GetStackFramesRequest;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugTarget;

public class EaseDebugThread
extends EaseDebugElement
implements IThread {
    private final Thread fThread;
    private final List<EaseDebugStackFrame> fStackFrames = new ArrayList<EaseDebugStackFrame>();

    public EaseDebugThread(EaseDebugTarget target, Thread thread) {
        super(target);
        this.fThread = thread;
    }

    public String getName() {
        return "Thread: " + this.fThread.getName();
    }

    public synchronized IStackFrame[] getStackFrames() {
        if (this.fStackFrames.isEmpty()) {
            this.getDebugTarget().fireDispatchEvent(new GetStackFramesRequest(this.getThread()));
            return new IStackFrame[0];
        }
        return this.fStackFrames.toArray(new IStackFrame[this.fStackFrames.size()]);
    }

    public boolean hasStackFrames() {
        return this.getStackFrames().length > 0;
    }

    public synchronized EaseDebugStackFrame getTopStackFrame() {
        if (this.hasStackFrames()) {
            return this.fStackFrames.get(0);
        }
        return null;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public Thread getThread() {
        return this.fThread;
    }

    public synchronized void setStackFrames(List<IScriptDebugFrame> debugFrames) {
        ArrayList<EaseDebugStackFrame> oldStackFrames = new ArrayList<EaseDebugStackFrame>(this.fStackFrames);
        this.fStackFrames.clear();
        for (IScriptDebugFrame debugFrame : debugFrames) {
            EaseDebugStackFrame stackFrame = null;
            for (EaseDebugStackFrame oldStackFrame : oldStackFrames) {
                if (!debugFrame.equals(oldStackFrame.getDebugFrame())) continue;
                stackFrame = oldStackFrame;
                this.fStackFrames.add(stackFrame);
                oldStackFrame.setDirty();
                break;
            }
            if (stackFrame == null) {
                stackFrame = new EaseDebugStackFrame(this, debugFrame);
                this.fStackFrames.add(stackFrame);
                stackFrame.fireCreationEvent();
                continue;
            }
            oldStackFrames.remove((Object)stackFrame);
        }
        for (EaseDebugStackFrame stackFrame : oldStackFrames) {
            stackFrame.fireTerminateEvent();
        }
        this.fireChangeEvent(512);
    }

    public String toString() {
        return this.getName();
    }
}

