/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.dnd;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.platform.ScriptingModule;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.ui.PlatformUI;

public class ForkDropHandler
implements IShellDropHandler {
    public boolean accepts(IScriptEngine scriptEngine, Object element) {
        if (element instanceof IFile || element instanceof File || element instanceof URI) {
            return ForkDropHandler.getScriptType(element) != null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        ScriptType scriptType = ForkDropHandler.getScriptType(element);
        if (scriptType == null) throw new RuntimeException("Could not detect script type of dropped resource");
        IEnvironment environment = IEnvironment.getEnvironment((IScriptEngine)scriptEngine);
        if (environment == null) throw new RuntimeException("No environment loaded, cannot execute dropped file");
        if (environment.getModule(ScriptingModule.class) == null && environment.loadModule("/System/Scripting", false) == null) {
            throw new RuntimeException("Cannot load module '/System/Scripting'");
        }
        scriptEngine.executeAsync((Object)("fork(\"" + ResourceTools.toAbsoluteLocation((Object)element, null) + "\")"));
    }

    private static ScriptType getScriptType(Object element) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        return scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)element, null));
    }
}

