/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling.ui.views;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ease.modules.modeling.ui.Activator;
import org.eclipse.ease.modules.modeling.ui.MatcherRegistry;
import org.eclipse.ease.modules.modeling.ui.Messages;
import org.eclipse.ease.modules.modeling.ui.exceptions.MatcherException;
import org.eclipse.ease.modules.modeling.ui.matchers.IMatcher;
import org.eclipse.ease.modules.modeling.ui.utils.SelectionUtils;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModelRefactoringView
extends ViewPart
implements ISelectionListener {
    private static final String ICONS_START_TASK_1_GIF = "icons/start_task-1.gif";
    private static final String ICONS_DELETE_OBJ_GIF = "icons/delete_obj.gif";
    public static final String ID = "org.eclipse.ease.modules.modeling.ui.view";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    List<StructuredViewer> viewers = new LinkedList<StructuredViewer>();
    ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Text text;
    private Form frmNavigation;
    private Text selectionId;
    private Table table_Search;
    private TableViewer tableViewer_Search;
    private ComboViewer comboViewer;

    public void dispose() {
        ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        service.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    protected boolean gotoInEditor(IEditingDomainProvider editor, EObject e) throws MatcherException {
        block18: {
            if (editor == null) {
                return false;
            }
            if (e != null) {
                if (editor instanceof IViewerProvider) {
                    IViewerProvider provider = (IViewerProvider)editor;
                    provider.getViewer().setSelection((ISelection)new TreeSelection(this.getTreePath(e)), true);
                    return true;
                }
                if (editor instanceof IGotoMarker) {
                    IGotoMarker gotoMarker = (IGotoMarker)editor;
                    EObject root = SelectionUtils.getSelection(editor);
                    Resource r = root.eResource();
                    IFile f = WorkspaceSynchronizer.getFile((Resource)r);
                    IMarker marker = null;
                    try {
                        try {
                            marker = f.createMarker("org.eclipse.emf.ecore.diagnostic");
                            marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)e).toString());
                            marker.setAttribute("message", (Object)"");
                            marker.setAttribute("severity", 0);
                            gotoMarker.gotoMarker(marker);
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                            if (marker != null) {
                                try {
                                    marker.delete();
                                }
                                catch (CoreException coreException) {}
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (marker != null) {
                            try {
                                marker.delete();
                            }
                            catch (CoreException coreException) {}
                        }
                        throw throwable;
                    }
                    if (marker != null) {
                        try {
                            marker.delete();
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        }
        return false;
    }

    private TreePath getTreePath(EObject e) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        while (e != null) {
            result.addFirst(e);
            e = e.eContainer();
        }
        return new TreePath(result.toArray());
    }

    protected IEditingDomainProvider getCurrentEditor() {
        IWorkbenchPage activePage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (activePage = window.getActivePage()) != null && activePage.getActiveEditor() instanceof IEditingDomainProvider) {
            IEditingDomainProvider editor = (IEditingDomainProvider)activePage.getActiveEditor();
            return editor;
        }
        return null;
    }

    protected void handleGoto() {
        IStructuredSelection structured;
        String theText = this.text.getText();
        this.frmNavigation.setMessage(null);
        ISelection selec = this.comboViewer.getSelection();
        if (selec instanceof IStructuredSelection && (structured = (IStructuredSelection)selec).getFirstElement() instanceof IMatcher) {
            IMatcher matcher = (IMatcher)structured.getFirstElement();
            try {
                Collection<EObject> toUse = matcher.getElements(theText, this.getCurrentEditor());
                toUse.remove(null);
                if (toUse.isEmpty() && this.frmNavigation.getMessage() == null) {
                    this.frmNavigation.setMessage(Messages.ModelRefactoringView_NO_ELEMENTS, 2);
                }
                this.tableViewer_Search.setInput(toUse);
                this.frmNavigation.setMessage(String.valueOf(toUse.size()) + Messages.ModelRefactoringView_NB_ELEMENTS_FOUND, 1);
            }
            catch (MatcherException e) {
                this.frmNavigation.setMessage(e.getMessage(), 3);
                e.printStackTrace();
            }
        }
    }

    private Image getFromRegistry(String key, ImageDescriptor desc) {
        Image i = Activator.getDefault().getImageRegistry().get(key);
        if (i == null) {
            Activator.getDefault().getImageRegistry().put(key, desc);
            i = Activator.getDefault().getImageRegistry().get(key);
        }
        return i;
    }

    public void createPartControl(Composite parent) {
        ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        service.addSelectionListener((ISelectionListener)this);
        this.frmNavigation = this.formToolkit.createForm(parent);
        this.formToolkit.paintBordersFor((Composite)this.frmNavigation);
        this.frmNavigation.setText(Messages.ModelRefactoringView_NAVIGATION);
        this.frmNavigation.getBody().setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(this.frmNavigation.getBody(), 0);
        tabFolder.setBackground(Display.getDefault().getSystemColor(1));
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.adapt((Composite)tabFolder);
        this.formToolkit.paintBordersFor((Composite)tabFolder);
        TabItem tbtmSearch = new TabItem(tabFolder, 0);
        tbtmSearch.setText(Messages.ModelRefactoringView_SEARCH);
        Composite composite_2 = this.formToolkit.createComposite((Composite)tabFolder, 0);
        tbtmSearch.setControl((Control)composite_2);
        this.formToolkit.paintBordersFor(composite_2);
        composite_2.setLayout((Layout)new GridLayout(4, false));
        Label lblSelectionId = new Label(composite_2, 0);
        lblSelectionId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)lblSelectionId, true, true);
        lblSelectionId.setText(Messages.ModelRefactoringView_SELECTION_ID);
        this.selectionId = new Text(composite_2, 2048);
        this.selectionId.setEditable(false);
        this.selectionId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.formToolkit.adapt((Control)this.selectionId, true, true);
        this.comboViewer = new ComboViewer(composite_2, 8);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMatcher)element).getText();
            }
        });
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selec;
                if (event.getSelection() instanceof IStructuredSelection && (selec = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof IMatcher) {
                    final IMatcher matcher = (IMatcher)selec.getFirstElement();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelRefactoringView.this.text.setToolTipText(matcher.getHelp());
                        }
                    });
                }
            }
        });
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setInput(MatcherRegistry.getMatchers());
        this.comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.formToolkit.adapt((Control)this.comboViewer.getCombo(), true, true);
        Button btnGo = new Button(composite_2, 0);
        btnGo.setImage(this.getFromRegistry(ICONS_START_TASK_1_GIF, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.modules.modeling.ui", (String)ICONS_START_TASK_1_GIF)));
        btnGo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRefactoringView.this.handleGoto();
            }
        });
        this.formToolkit.adapt((Control)btnGo, true, true);
        Button btnDel = new Button(composite_2, 0);
        btnDel.setImage(this.getFromRegistry(ICONS_DELETE_OBJ_GIF, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.modules.modeling.ui", (String)ICONS_DELETE_OBJ_GIF)));
        btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRefactoringView.this.clearResult();
            }
        });
        this.formToolkit.adapt((Control)btnDel, true, true);
        this.text = new Text(composite_2, 2048);
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    ModelRefactoringView.this.handleGoto();
                }
            }
        });
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.formToolkit.adapt((Control)this.text, true, true);
        this.tableViewer_Search = new TableViewer(composite_2, 268437506);
        this.tableViewer_Search.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection structured;
                if (event.getSelection() instanceof IStructuredSelection && (structured = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
                    EObject eo = (EObject)structured.getFirstElement();
                    try {
                        ModelRefactoringView.this.gotoInEditor(ModelRefactoringView.this.getCurrentEditor(), eo);
                    }
                    catch (MatcherException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.table_Search = this.tableViewer_Search.getTable();
        this.table_Search.setHeaderVisible(true);
        this.table_Search.setLinesVisible(true);
        this.table_Search.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.formToolkit.paintBordersFor((Composite)this.table_Search);
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.tableViewer_Search, 0);
        TableColumn tblclmnElement_1 = tableViewerColumn_5.getColumn();
        tblclmnElement_1.setWidth(100);
        tblclmnElement_1.setText(Messages.ModelRefactoringView_ELEMENT);
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(this.tableViewer_Search, 0);
        TableColumn tblclmnPath = tableViewerColumn_6.getColumn();
        tblclmnPath.setWidth(229);
        tblclmnPath.setText(Messages.ModelRefactoringView_PATH);
        this.tableViewer_Search.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer_Search.setLabelProvider((IBaseLabelProvider)new DefaultTableLabelProvider(this){

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.p.getImage(element);
                    }
                }
                return super.getColumnImage(element, columnIndex);
            }

            @Override
            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.p.getText(element);
                    }
                    case 1: {
                        if (!(element instanceof EObject)) break;
                        EObject e = ((EObject)element).eContainer();
                        StringBuilder result = new StringBuilder();
                        while (e != null) {
                            result = new StringBuilder(this.p.getText((Object)e)).append("\\").append((CharSequence)result);
                            e = e.eContainer();
                        }
                        return result.toString();
                    }
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
                ModelRefactoringView.this.tableViewer_Search.setSelection(selection);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                ModelRefactoringView.this.tableViewer_Search.removeSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return ModelRefactoringView.this.tableViewer_Search.getSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                ModelRefactoringView.this.tableViewer_Search.addSelectionChangedListener(listener);
            }
        });
    }

    protected void clearResult() {
        this.frmNavigation.setMessage(null);
        this.tableViewer_Search.setInput((Object)Lists.newArrayList());
    }

    public void setFocus() {
        this.tableViewer_Search.getControl().setFocus();
    }

    public ISelection getSelection() {
        return this.tableViewer_Search.getSelection();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.frmNavigation.setMessage(null);
        if (part != this && selection instanceof IStructuredSelection) {
            IAdaptable iadaptable;
            EObject eobject;
            IStructuredSelection structured = (IStructuredSelection)selection;
            if (structured.getFirstElement() instanceof EObject) {
                EObject eobject2 = (EObject)structured.getFirstElement();
                this.handleSelectionCHanged(eobject2);
            } else if (structured.getFirstElement() instanceof IAdaptable && (eobject = (EObject)(iadaptable = (IAdaptable)structured.getFirstElement()).getAdapter(EObject.class)) != null) {
                this.handleSelectionCHanged(eobject);
            }
        }
    }

    private void handleSelectionCHanged(EObject eobject) {
        this.selectionId.setText(eobject.eResource().getURIFragment(eobject).toString());
        for (StructuredViewer v : this.viewers) {
            v.setInput((Object)eobject);
        }
    }

    public void setSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer_Search);
    }

    public class DefaultContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return null;
        }
    }

    public class DefaultTableLabelProvider
    implements ITableLabelProvider {
        protected AdapterFactoryLabelProvider p;

        public DefaultTableLabelProvider() {
            this.p = new AdapterFactoryLabelProvider((AdapterFactory)ModelRefactoringView.this.factory);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.p.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.p.getText(element);
            }
            return "";
        }
    }
}

