/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.completion;

import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.completion.provider.AbstractFileLocationCompletionProvider;
import org.eclipse.ui.PlatformUI;

public class ResourcesCompletionProvider
extends AbstractFileLocationCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        if (super.isActive(context)) {
            if (context.getLoadedModules().contains(ResourcesCompletionProvider.getModule("/System/Resources"))) {
                if (context.getCaller().endsWith("copyFile") || context.getCaller().endsWith("createFile") || context.getCaller().endsWith("createFolder") || context.getCaller().endsWith("deleteFile") || context.getCaller().endsWith("deleteFolder") || context.getCaller().endsWith("fileExists")) {
                    return true;
                }
                if (context.getCaller().endsWith("findFiles") && context.getParameterOffset() == 1) {
                    return true;
                }
                if (context.getCaller().endsWith("getFile") && context.getParameterOffset() == 0) {
                    return true;
                }
                if (context.getCaller().endsWith("openFile") && context.getParameterOffset() == 0) {
                    return true;
                }
                if (context.getCaller().endsWith("readFile") && context.getParameterOffset() == 0) {
                    return true;
                }
                if (context.getCaller().endsWith("writeFile") && context.getParameterOffset() == 0) {
                    return true;
                }
                if (context.getCaller().endsWith("createProblemMarker") && context.getParameterOffset() == 1) {
                    return true;
                }
            }
            if (context.getLoadedModules().contains(ResourcesCompletionProvider.getModule("/System/Scripting")) && context.getCaller().endsWith("fork") && context.getParameterOffset() == 0) {
                return true;
            }
            if (context.getLoadedModules().contains(ResourcesCompletionProvider.getModule("/System/UI")) && (context.getCaller().endsWith("showEditor") || context.getCaller().endsWith("openEditor"))) {
                return true;
            }
        }
        return false;
    }

    protected boolean showCandidate(Object candidate) {
        String caller = this.getContext().getCaller();
        if (caller.endsWith("showEditor") || caller.endsWith("openEditor")) {
            return !ResourcesCompletionProvider.isFileSystemResource((Object)candidate);
        }
        if (caller.endsWith("createFile") || caller.endsWith("createFolder") || caller.endsWith("deleteFolder") || caller.endsWith("findFiles")) {
            return !ResourcesCompletionProvider.isFile((Object)candidate);
        }
        return super.showCandidate(candidate);
    }

    private static ModuleDefinition getModule(String identifier) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        return (ModuleDefinition)scriptService.getAvailableModules().get(identifier);
    }
}

