/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.swt.widgets.Display;

public class LaunchModule
extends AbstractScriptModule {
    public static final String MODULE_NAME = "/System/Launch";

    @WrapToScript
    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    @WrapToScript
    public static String[] getLaunchConfigurationNames() throws CoreException {
        ILaunchConfiguration[] configurations = LaunchModule.getLaunchConfigurations();
        String[] names = new String[configurations.length];
        int i = 0;
        while (i < names.length) {
            names[i] = configurations[i].getName();
            ++i;
        }
        return names;
    }

    @WrapToScript
    public static ILaunchConfiguration[] getLaunchConfigurations() throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
    }

    @WrapToScript
    public static ILaunchConfiguration getLaunchConfiguration(String name) throws CoreException, IllegalArgumentException {
        ILaunchConfiguration[] configurations;
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations = LaunchModule.getLaunchConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            if (configuration.getName().equals(name)) {
                return configuration;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown launch configuration name, use getLaunchConfigurationNames() to obtain all names");
    }

    @WrapToScript
    public static ILaunch launch(Object launchConfiguration, @ScriptParameter(defaultValue="run") String mode) throws CoreException {
        ILaunchConfiguration config = launchConfiguration instanceof ILaunchConfiguration ? (ILaunchConfiguration)launchConfiguration : LaunchModule.getLaunchConfiguration(launchConfiguration.toString());
        return config.launch(mode, (IProgressMonitor)new NullProgressMonitor());
    }

    @WrapToScript
    public static void launchUI(Object launchConfiguration, final @ScriptParameter(defaultValue="run") String mode) throws CoreException {
        final ILaunchConfiguration config = launchConfiguration instanceof ILaunchConfiguration ? (ILaunchConfiguration)launchConfiguration : LaunchModule.getLaunchConfiguration(launchConfiguration.toString());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        });
    }
}

