/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.modules;

import java.io.IOException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.IScriptFunctionModifier;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.IFileHandle;
import org.eclipse.ease.modules.platform.ResourcesModule;
import org.eclipse.ease.modules.unittest.components.Test;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.modules.DefaultAssertion;
import org.eclipse.ease.modules.unittest.modules.IAssertion;
import org.eclipse.ease.modules.unittest.modules.MergedAssertion;
import org.eclipse.ease.modules.unittest.reporters.IReportGenerator;
import org.eclipse.ease.modules.unittest.reporters.ReportTools;
import org.eclipse.ease.tools.ResourceTools;

public class UnitTestModule
extends AbstractScriptModule
implements IScriptFunctionModifier {
    public static final String MODULE_NAME = "Unittest";
    private static final String ASSERTION_FUNCION_NAME = "assertion";
    public static final String INJECTED_MAIN = "injected_code_";
    public static final String FAIL_ON_ERROR_VARIABLE = "__FAIL_ON_ERROR";
    private boolean fAssertionEnablement = true;
    private int fAssertionsToBeIgnored = 0;

    @WrapToScript
    public TestSuite runUnitTest(Object executable) {
        if (executable instanceof TestSuite) {
            ((TestSuite)executable).run();
            return (TestSuite)executable;
        }
        if (!(executable instanceof IFile)) {
            executable = ResourceTools.resolveFile((Object)executable.toString(), (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        }
        if (executable instanceof IFile && ((IFile)executable).exists()) {
            try {
                if ("suite".equalsIgnoreCase(((IFile)executable).getFileExtension())) {
                    TestSuiteModel description = new TestSuiteModel((IFile)executable);
                    TestSuite testSuite = new TestSuite(description);
                    testSuite.run();
                    return testSuite;
                }
                if ("js".equalsIgnoreCase(((IFile)executable).getFileExtension())) {
                    TestSuiteModel description = new TestSuiteModel();
                    TestSuite testSuite = new TestSuite(description);
                    testSuite.run();
                    return testSuite;
                }
            }
            catch (Exception e) {
                this.getScriptEngine().getErrorStream().println("Error executing unit test suite: " + e.getLocalizedMessage());
            }
        }
        return null;
    }

    @WrapToScript
    public TestSuite openTestSuite(String filename) throws IOException, CoreException {
        Object file = ResourceTools.resolveFile((Object)filename, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (file instanceof IFile && ((IFile)file).exists() && "suite".equalsIgnoreCase(((IFile)file).getFileExtension())) {
            TestSuite suite = new TestSuite(new TestSuiteModel((IFile)file));
            suite.setOutputStream(this.getScriptEngine().getOutputStream());
            suite.setErrorStream(this.getScriptEngine().getErrorStream());
            return suite;
        }
        return null;
    }

    @WrapToScript
    public boolean createReport(String reportType, TestSuite suite, String fileLocation, String title, String description) throws Exception {
        Object file = ResourceTools.resolveFile((Object)fileLocation, (Object)this.getScriptEngine().getExecutedFile(), (boolean)false);
        IReportGenerator report = ReportTools.getReport(reportType);
        if (report != null) {
            String reportData = report.createReport(title, description, suite);
            IFileHandle handle = ((ResourcesModule)this.getEnvironment().getModule(ResourcesModule.class)).writeFile(file, reportData, 2);
            ResourcesModule.closeFile((IFileHandle)handle);
            return true;
        }
        return false;
    }

    @WrapToScript
    public static String[] getReportTypes() {
        return ReportTools.getReportTemplates().toArray(new String[0]);
    }

    public String getPreExecutionCode(Method method) {
        return "";
    }

    public String getPostExecutionCode(Method method) {
        if (UnitTestModule.returnsAssertion(method)) {
            return "\tassertion(__result);\n\n";
        }
        return "";
    }

    private static boolean returnsAssertion(Method method) {
        Class<?> returnType = method.getReturnType();
        return IAssertion.class.isAssignableFrom(returnType);
    }

    @WrapToScript
    public final void startTest(String title, @ScriptParameter(defaultValue="") String description) {
        this.fAssertionsToBeIgnored = 0;
        this.fAssertionEnablement = true;
        this.executeUserCode("Test Setup");
        TestComposite testObject = this.getTestObject();
        if (testObject != null) {
            Test test = new Test(testObject, title, description);
            IScriptEngine engine = this.getScriptEngine();
            if (engine instanceof IDebugEngine) {
                test.setTestLocation(((IDebugEngine)engine).getStackTrace());
            } else if (engine instanceof AbstractScriptEngine) {
                test.setTestLocation(((AbstractScriptEngine)engine).getStackTrace());
            }
            testObject.addTest(test);
        }
    }

    @WrapToScript
    public final void endTest() {
        TestComposite testObject = this.getTestObject();
        if (testObject != null) {
            testObject.endTest();
        }
        this.executeUserCode("Test Teardown");
    }

    @WrapToScript
    public final void assertion(IAssertion reason) {
        if (this.fAssertionEnablement) {
            if (this.fAssertionsToBeIgnored == 0) {
                if (!reason.isValid()) {
                    if (reason instanceof MergedAssertion) {
                        for (IAssertion mergedReason : ((MergedAssertion)reason).getAssertions()) {
                            if (mergedReason.isValid()) continue;
                            this.error(mergedReason.toString());
                        }
                    }
                    this.error(reason.toString());
                }
            } else {
                --this.fAssertionsToBeIgnored;
            }
        }
    }

    @WrapToScript
    public final void error(String message) {
        TestComposite testObject = this.getTestObject();
        if (testObject != null) {
            Object failOnError = this.getScriptEngine().getVariable(FAIL_ON_ERROR_VARIABLE);
            if (failOnError instanceof Boolean && ((Boolean)failOnError).booleanValue()) {
                testObject.addTestResult(TestStatus.FAILURE, message);
                throw new RuntimeException("Unit Failure: " + message);
            }
            testObject.addTestResult(TestStatus.ERROR, message);
        }
    }

    @WrapToScript
    public final void failure(String message) {
        TestComposite testObject = this.getTestObject();
        if (testObject != null) {
            testObject.addTestResult(TestStatus.FAILURE, message);
        }
        throw new RuntimeException("Unit Failure: " + message);
    }

    @WrapToScript
    public TestFile getTestFile() {
        TestComposite testObject = this.getTestObject();
        if (testObject instanceof TestFile) {
            return (TestFile)testObject;
        }
        return null;
    }

    @WrapToScript
    public Test getTest(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String name) {
        if (name == null) {
            return this.getTestFile().getCurrentTest();
        }
        for (TestEntity testEntity : this.getTestFile().getChildren()) {
            if (!(testEntity instanceof Test) || !name.equals(((Test)testEntity).getTitle())) continue;
            return (Test)testEntity;
        }
        return null;
    }

    private TestComposite getTestObject() {
        Object testObject = this.getScriptEngine().getVariable("__internal_testObject");
        if (testObject instanceof TestComposite) {
            return (TestComposite)testObject;
        }
        return null;
    }

    @WrapToScript
    public TestSuite getTestSuite() {
        TestComposite testObject = this.getTestObject();
        if (testObject instanceof TestSuite) {
            return (TestSuite)testObject;
        }
        if (testObject instanceof TestFile) {
            return ((TestFile)testObject).getTestSuite();
        }
        return null;
    }

    @WrapToScript
    public final void executeUserCode(String identifier) {
        String code;
        if (this.getTestObject() != null && (code = this.getTestSuite().getModel().getCodeFragment(identifier)) != null && !code.isEmpty()) {
            this.getScriptEngine().inject((Object)code);
        }
    }

    @WrapToScript
    public static IAssertion assertEquals(Object expected, Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        if (expected != null) {
            return new DefaultAssertion(expected.equals(actual), errorDescription == null ? "Objects do not match: expected<" + expected + ">, actual <" + actual + ">" : errorDescription.toString());
        }
        return UnitTestModule.assertNull(actual, errorDescription);
    }

    @WrapToScript
    public static IAssertion assertNotEquals(Object expected, Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        if (expected != null) {
            return new DefaultAssertion(!expected.equals(actual), errorDescription == null ? "Objects match" : errorDescription.toString());
        }
        return UnitTestModule.assertNotNull(actual, errorDescription);
    }

    @WrapToScript
    public static IAssertion assertNull(Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual == null, errorDescription == null ? "Object is not null, actual <" + actual + ">" : errorDescription.toString());
    }

    @WrapToScript
    public static IAssertion assertNotNull(Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual != null, errorDescription == null ? "Object is null" : errorDescription.toString());
    }

    @WrapToScript
    public static IAssertion assertTrue(boolean actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual, errorDescription == null ? "Value is false" : errorDescription.toString());
    }

    @WrapToScript
    public static IAssertion assertFalse(boolean actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(!actual, errorDescription == null ? "Value is true" : errorDescription.toString());
    }

    @WrapToScript
    public void disableAssertions() {
        this.fAssertionEnablement = false;
    }

    @WrapToScript
    public void enableAssertions() {
        this.fAssertionEnablement = true;
        this.fAssertionsToBeIgnored = 0;
    }

    @WrapToScript
    public void ignoreAssertions(int count) {
        assert (count >= 0);
        this.fAssertionsToBeIgnored = count;
    }

    @WrapToScript
    public static boolean waitForCompletion(TestComposite testObject) {
        try {
            while (testObject.getStatus() == TestStatus.NOT_RUN || testObject.getStatus() == TestStatus.RUNNING) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    @WrapToScript
    public void addMetaData(String key, String data) {
        TestComposite testObject = this.getTestObject();
        testObject.getCurrentTest().addMetaData(key, data);
    }
}

