/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger.actions;

import org.eclipse.debug.ui.IDebugView;
import org.eclipse.ease.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class ViewFilterAction
extends ViewerFilter
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    private IAction fAction;
    private final IPropertyChangeListener fListener = new Updater();

    public void init(IViewPart view) {
        this.fView = view;
        this.fAction.setChecked(this.getPreferenceValue());
        this.run(this.fAction);
        this.getPreferenceStore().addPropertyChangeListener(this.fListener);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener(this.fListener);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        StructuredViewer viewer = this.getStructuredViewer();
        ViewerFilter[] filters = viewer.getFilters();
        ViewerFilter filter = null;
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == this) {
                filter = filters[i];
                break;
            }
            ++i;
        }
        if (filter == null) {
            viewer.addFilter((ViewerFilter)this);
        } else {
            viewer.refresh();
        }
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(this.getPreferenceKey(), action.isChecked());
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected boolean getPreferenceValue() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(this.getPreferenceKey());
    }

    protected abstract String getPreferenceKey();

    protected String getCompositeKey() {
        String baseKey = this.getPreferenceKey();
        String viewKey = this.getView().getSite().getId();
        return String.valueOf(viewKey) + "." + baseKey;
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected boolean getValue() {
        return this.fAction.isChecked();
    }

    class Updater
    implements IPropertyChangeListener {
        Updater() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(ViewFilterAction.this.getPreferenceKey()) || event.getProperty().equals(ViewFilterAction.this.getCompositeKey())) {
                ViewFilterAction.this.fAction.setChecked(ViewFilterAction.this.getPreferenceValue());
            }
        }
    }
}

