/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.dialogs.SuiteSelectionDialog;
import org.eclipse.ease.modules.unittest.ui.views.UnitTestView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LoadSuite
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "org.eclipse.ease.unittest.commands.loadTestSuite";
    public static final String PARAMETER_SUITE_NAME = "org.eclipse.ease.unittest.commands.loadTestSuite.suite";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof UnitTestView) {
            IFile suiteFile;
            IFile result;
            SuiteSelectionDialog dialog;
            String fileName = event.getParameter(PARAMETER_SUITE_NAME);
            if (fileName == null && (dialog = new SuiteSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event))).open() == 0 && (result = dialog.getSuiteFile()) != null) {
                fileName = result.getFullPath().toString();
            }
            if (fileName != null && (suiteFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName))).exists()) {
                try {
                    ((UnitTestView)part).loadSuite(new TestSuite(new TestSuiteModel(suiteFile)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }
}

