/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizards.rename;

import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.shared.ValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.Messages;

public class RenameWizardModel {
    private static final String COULD_NOT_RENAME_RESOURCE = Messages.RenameWizardModel_COULD_NOT_RENAME_RESOURCE;
    private static final String A_RESOURCE_WITH_THIS_NAME_ALREADY_EXISTS = Messages.RenameWizardModel_A_RESOURCE_WITH_THIS_NAME_ALREADY_EXISTS;
    private static final String INVALID_RESOURCE_NAME = Messages.RenameWizardModel_INVALID_RESOURCE_NAME;
    private final IResource resource;
    private String resourceName;

    public RenameWizardModel(IResource resource) {
        this.resource = resource;
        this.resourceName = resource.getName();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ValidationStatus validate() {
        IPath parentPath;
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IStatus nameValidation = workspace.validateName(this.resourceName, this.resource.getType());
        if (!nameValidation.isOK()) {
            return ValidationStatus.createError(INVALID_RESOURCE_NAME);
        }
        IWorkspaceRoot root = workspace.getRoot();
        IResource existing = root.findMember((parentPath = this.resource.getParent().getFullPath()).append(this.resourceName));
        if (existing != null) {
            return ValidationStatus.createError(A_RESOURCE_WITH_THIS_NAME_ALREADY_EXISTS);
        }
        return ValidationStatus.createOk();
    }

    public void persist() throws IOException {
        IPath destination = this.resource.getParent().getFullPath().append(this.resourceName);
        try {
            this.resource.move(destination, false, null);
        }
        catch (CoreException ex) {
            throw new IOException(COULD_NOT_RENAME_RESOURCE, ex);
        }
    }
}

