/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Iterator;
import org.eclipse.dirigible.runtime.command.CommandData;
import org.eclipse.dirigible.runtime.command.CommandLineData;

public class CommandDataParser {
    public static CommandData parseCommandData(String commandSource) throws IllegalArgumentException {
        JsonParser parser = new JsonParser();
        JsonObject commandObject = (JsonObject)parser.parse(commandSource);
        CommandData commandData = new CommandData();
        commandData.setDescription(commandObject.get("description").getAsString());
        commandData.setContentType(commandObject.get("contentType").getAsString());
        commandData.setUseContent(commandObject.get("useContent").getAsBoolean());
        commandData.setWorkDir(commandObject.get("workDir").getAsString());
        JsonArray commandsData = commandObject.get("commands").getAsJsonArray();
        Iterator iter = commandsData.iterator();
        while (iter.hasNext()) {
            CommandLineData commandLineData = new CommandLineData();
            JsonObject object = (JsonObject)iter.next();
            commandLineData.setOsName(object.get("osName").getAsString());
            commandLineData.setCommand(object.get("command").getAsString());
            commandData.getCommands().add(commandLineData);
        }
        JsonArray envAddData = commandObject.get("envAdd").getAsJsonArray();
        for (JsonObject object : envAddData) {
            commandData.getEnvAdd().put(object.get("name").getAsString(), object.get("value").getAsString());
        }
        JsonArray envRemoveData = commandObject.get("envRemove").getAsJsonArray();
        for (JsonObject object : envRemoveData) {
            commandData.getEnvRemove().add(object.get("name").getAsString());
        }
        CommandDataParser.validateCommandData(commandData);
        return commandData;
    }

    private static void validateCommandData(CommandData commandData) throws IllegalArgumentException {
        if (commandData.getCommands().size() == 0) {
            throw new IllegalArgumentException("Commands array is empty. Set appropriate command per target OS");
        }
        String os = System.getProperty("os.name").toLowerCase();
        for (CommandLineData commandLineData : commandData.getCommands()) {
            if (!os.startsWith(commandLineData.getOsName().toLowerCase())) continue;
            commandData.setTargetCommand(commandLineData);
            break;
        }
        if (commandData.getTargetCommand() == null) {
            throw new IllegalArgumentException(String.format("There is no command for your OS: %s", os));
        }
    }
}

