/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.services.security.manager.views;

import javax.sql.DataSource;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.services.security.manager.views.Messages;
import org.eclipse.dirigible.ide.services.security.manager.views.SecurityViewContentProvider;
import org.eclipse.dirigible.ide.services.security.manager.views.SecurityViewLabelProvider;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.security.SecurityException;
import org.eclipse.dirigible.repository.ext.security.SecurityLocationMetadata;
import org.eclipse.dirigible.repository.ext.security.SecurityManager;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SecurityManagerView
extends ViewPart {
    private static final String REFRESH_THE_LIST_OF_PROTECTED_LOCATIONS = Messages.SecurityManagerView_REFRESH_THE_LIST_OF_PROTECTED_LOCATIONS;
    private static final String REFRESH = Messages.SecurityManagerView_REFRESH;
    private static final String REMOVE_THE_SELECTED_LOCATION_FROM_THE_LIST_OF_PROTECTED_LOCATIONS = Messages.SecurityManagerView_REMOVE_THE_SELECTED_LOCATION_FROM_THE_LIST_OF_PROTECTED_LOCATIONS;
    private static final String ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THE_SELECTED_LOCATION_FROM_THE_LIST_OF_PROTECTED_LOCATIONS = Messages.SecurityManagerView_ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THE_SELECTED_LOCATION_FROM_THE_LIST_OF_PROTECTED_LOCATIONS;
    private static final String PROTECT_A_GIVEN_RELATIVE_URL_TRANSITIVELY = Messages.SecurityManagerView_PROTECT_A_GIVEN_RELATIVE_URL_TRANSITIVELY;
    private static final String PROTECTED_URL = Messages.SecurityManagerView_PROTECTED_URL;
    private static final String ROLES = Messages.SecurityManagerView_ROLES;
    private static final String LOCATION = Messages.SecurityManagerView_LOCATION;
    private static final String LOCATION_IS_TOO_LONG = Messages.SecurityManagerView_LOCATION_IS_TOO_LONG;
    private static final Logger logger = Logger.getLogger(SecurityManagerView.class);
    private static final String UNSECURE_LOCATION = Messages.SecurityManagerView_UNSECURE_LOCATION;
    private static final String SECURE_LOCATION = Messages.SecurityManagerView_SECURE_LOCATION;
    public static final String SECURITY_ERROR = Messages.SecurityManagerView_SECURITY_ERROR;
    public static final String ID = "org.eclipse.dirigible.ide.services.security.manager.views.SecurityManagerView";
    private TreeViewer viewer;
    private Action actionSecure;
    private Action actionUnsecure;
    private Action actionRefresh;
    private SecurityManager securityManager = SecurityManager.getInstance((IRepository)RepositoryFacade.getInstance().getRepository(), (DataSource)DataSourceFacade.getInstance().getDataSource());

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.getTree().setHeaderVisible(true);
        TreeColumn column = new TreeColumn(this.viewer.getTree(), 16384);
        column.setText(LOCATION);
        column.setWidth(300);
        column = new TreeColumn(this.viewer.getTree(), 16384);
        column.setText(ROLES);
        column.setWidth(500);
        this.viewer.setContentProvider((IContentProvider)new SecurityViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new SecurityViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private static final long serialVersionUID = -8683354310299838422L;

            public void menuAboutToShow(IMenuManager manager) {
                SecurityManagerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSecure);
        manager.add((IAction)this.actionUnsecure);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSecure);
        manager.add((IAction)this.actionUnsecure);
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSecure);
        manager.add((IAction)this.actionUnsecure);
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        this.actionSecure = new Action(){
            private static final long serialVersionUID = -6534944336694980431L;

            public void run() {
                InputDialog dlg = new InputDialog(SecurityManagerView.this.viewer.getControl().getShell(), SECURE_LOCATION, PROTECTED_URL, "/project1/securedFolder", (IInputValidator)new LengthValidator());
                if (dlg.open() == 0) {
                    try {
                        SecurityManagerView.this.securityManager.secureLocation(dlg.getValue(), CommonParameters.getRequest());
                        SecurityManagerView.this.viewer.refresh();
                    }
                    catch (SecurityException e) {
                        logger.error(SECURITY_ERROR, (Throwable)e);
                        MessageDialog.openError((Shell)SecurityManagerView.this.viewer.getControl().getShell(), (String)SECURITY_ERROR, (String)e.getMessage());
                    }
                }
            }
        };
        this.actionSecure.setText(SECURE_LOCATION);
        this.actionSecure.setToolTipText(PROTECT_A_GIVEN_RELATIVE_URL_TRANSITIVELY);
        this.actionSecure.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_STOP"));
        this.actionUnsecure = new Action(){
            private static final long serialVersionUID = 1336014167502247774L;

            public void run() {
                if (!SecurityManagerView.this.viewer.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)SecurityManagerView.this.viewer.getSelection();
                    SecurityLocationMetadata location = (SecurityLocationMetadata)selection.getFirstElement();
                    if (MessageDialog.openConfirm((Shell)SecurityManagerView.this.viewer.getControl().getShell(), (String)UNSECURE_LOCATION, (String)(String.valueOf(ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THE_SELECTED_LOCATION_FROM_THE_LIST_OF_PROTECTED_LOCATIONS) + location.getLocation()))) {
                        try {
                            SecurityManagerView.this.securityManager.unsecureLocation(location.getLocation());
                            SecurityManagerView.this.viewer.refresh();
                        }
                        catch (SecurityException e) {
                            logger.error(SECURITY_ERROR, (Throwable)e);
                            MessageDialog.openError((Shell)SecurityManagerView.this.viewer.getControl().getShell(), (String)SECURITY_ERROR, (String)e.getMessage());
                        }
                    }
                }
            }
        };
        this.actionUnsecure.setText(UNSECURE_LOCATION);
        this.actionUnsecure.setToolTipText(REMOVE_THE_SELECTED_LOCATION_FROM_THE_LIST_OF_PROTECTED_LOCATIONS);
        this.actionUnsecure.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.actionRefresh = new Action(){
            private static final long serialVersionUID = 506492927597193506L;

            public void run() {
                SecurityManagerView.this.viewer.refresh();
            }
        };
        this.actionRefresh.setText(REFRESH);
        this.actionRefresh.setToolTipText(REFRESH_THE_LIST_OF_PROTECTED_LOCATIONS);
        this.actionRefresh.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class LengthValidator
    implements IInputValidator {
        private static final long serialVersionUID = 553319995495098208L;

        LengthValidator() {
        }

        public String isValid(String newText) {
            int len = newText.length();
            if (len > 1000) {
                return LOCATION_IS_TOO_LONG;
            }
            return null;
        }
    }

    class NameSorter
    extends ViewerSorter {
        private static final long serialVersionUID = -8832089975378999206L;

        NameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 != null && e2 != null && e1 instanceof SecurityLocationMetadata && e2 instanceof SecurityLocationMetadata) {
                return super.compare(viewer, (Object)((SecurityLocationMetadata)e1).getLocation(), (Object)((SecurityLocationMetadata)e2).getLocation());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

