/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.command;

import java.io.IOException;
import java.util.SortedSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.repository.ui.command.AbstractClipboardHandler;
import org.eclipse.dirigible.ide.repository.ui.command.Clipboard;
import org.eclipse.dirigible.ide.repository.ui.command.Messages;
import org.eclipse.dirigible.ide.repository.ui.command.RefreshHandler;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.jface.dialogs.MessageDialog;

public class PasteHandler
extends AbstractClipboardHandler {
    private static final String SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_PASTED = Messages.PasteHandler_SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_PASTED;
    private static final String PASTE_ERROR = Messages.PasteHandler_PASTE_ERROR;

    @Override
    protected void execute(ExecutionEvent event, SortedSet<IEntity> resources) {
        if (resources.size() == 0) {
            return;
        }
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        String targetReposiotryPath = resources.first().getPath().toString();
        Clipboard clipboard = Clipboard.getInstance();
        String command = clipboard.getCommand();
        IOException throwable = null;
        if ("REPOSITORY_CUT".equals(command) || "REPOSITORY_COPY".equals(command)) {
            for (IEntity resource : clipboard) {
                block8: {
                    String sourceRepositoryPath = resource.getPath().toString();
                    try {
                        byte[] data = repository.exportZip(sourceRepositoryPath, true);
                        repository.importZip(data, targetReposiotryPath);
                    }
                    catch (IOException e) {
                        if (throwable != null) break block8;
                        throwable = e;
                    }
                }
                if (!"REPOSITORY_CUT".equals(command)) continue;
                try {
                    resource.delete();
                }
                catch (IOException e) {
                    if (throwable != null) continue;
                    throwable = e;
                }
            }
        }
        if (throwable != null) {
            MessageDialog.openWarning(null, (String)PASTE_ERROR, (String)SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_PASTED);
        }
        RefreshHandler.refreshActivePart(event);
    }
}

