/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.impl.tools.ij.AsyncStatement;
import org.apache.derby.impl.tools.ij.utilMain;

class Session {
    static final String DEFAULT_NAME = "CONNECTION";
    boolean singleSession = true;
    Connection conn = null;
    String tag;
    String name;
    Hashtable prepStmts = new Hashtable();
    Hashtable cursorStmts = new Hashtable();
    Hashtable cursors = new Hashtable();
    Hashtable asyncStmts = new Hashtable();
    boolean isJCC = false;
    boolean isDNC = false;
    boolean isEmbeddedDerby = false;

    Session(Connection connection, String string, String string2) {
        this.conn = connection;
        this.tag = string;
        this.name = string2;
        try {
            this.isJCC = this.conn.getMetaData().getDriverName().startsWith("IBM DB2 JDBC Universal Driver");
            this.isDNC = this.conn.getMetaData().getDriverName().startsWith("Apache Derby Network Client");
            this.isEmbeddedDerby = this.conn.getMetaData().getDriverName().startsWith("Apache Derby Embedded JDBC Driver");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    Connection getConnection() {
        return this.conn;
    }

    boolean getIsJCC() {
        return this.isJCC;
    }

    boolean getIsDNC() {
        return this.isDNC;
    }

    boolean getIsEmbeddedDerby() {
        return this.isEmbeddedDerby;
    }

    String getName() {
        return this.name;
    }

    Object addPreparedStatement(String string, PreparedStatement preparedStatement) {
        return this.prepStmts.put(string, preparedStatement);
    }

    Object addCursorStatement(String string, Statement statement) {
        return this.cursorStmts.put(string, statement);
    }

    Object addCursor(String string, ResultSet resultSet) {
        return this.cursors.put(string, resultSet);
    }

    Object addAsyncStatement(String string, AsyncStatement asyncStatement) {
        return this.asyncStmts.put(string, asyncStatement);
    }

    PreparedStatement getPreparedStatement(String string) {
        return (PreparedStatement)this.prepStmts.get(string);
    }

    Statement getCursorStatement(String string) {
        return (Statement)this.cursorStmts.get(string);
    }

    ResultSet getCursor(String string) {
        return (ResultSet)this.cursors.get(string);
    }

    AsyncStatement getAsyncStatement(String string) {
        return (AsyncStatement)this.asyncStmts.get(string);
    }

    boolean removePreparedStatement(String string) {
        return this.prepStmts.remove(string) != null;
    }

    boolean removeCursorStatement(String string) {
        return this.cursorStmts.remove(string) != null;
    }

    boolean removeCursor(String string) {
        return this.cursors.remove(string) != null;
    }

    void doPrompt(boolean bl, LocalizedOutput localizedOutput, boolean bl2) {
        if (bl2 && this.singleSession) {
            this.singleSession = false;
            this.tag = this.tag == null ? "(" + this.name + ")" : this.tag.substring(0, this.tag.length() - 1) + ":" + this.name + ")";
        }
        if (!bl2 && !this.singleSession) {
            this.singleSession = true;
            if (this.tag != null) {
                this.tag = this.tag.length() == this.name.length() + 2 ? null : this.tag.substring(0, this.tag.length() - 2 - this.name.length()) + ")";
            }
        }
        utilMain.doPrompt(bl, localizedOutput, this.tag);
    }

    void close() throws SQLException {
        if (!this.conn.isClosed()) {
            if (!this.conn.getAutoCommit() && this.name != null && !this.name.startsWith("XA")) {
                this.conn.rollback();
            }
            this.conn.close();
        }
        this.prepStmts.clear();
        this.cursorStmts.clear();
        this.cursors.clear();
        this.asyncStmts.clear();
        this.conn = null;
    }
}

