/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards.templates;

import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractBijectiveTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractRoleSpecificationPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCreationRolesPage
extends AbstractRoleSpecificationPage<AbstractBijectiveTemplatePatternSpecification> {
    public TemplateCreationRolesPage(AbstractBijectiveTemplatePatternSpecification data_p) {
        super(Messages.PatternCreationRolesPage_Name, Messages.TemplateCreationRolesPage_Message, data_p, false);
    }

    @Override
    protected void createMergeGroup(Composite parent_p) {
        Group mergeComposite = this.createGroup(parent_p, Messages.TemplateCreationRolesPage_MergeGroup, true, 3);
        this.fillLineWith((Control)mergeComposite);
        this.createTargetDerivationLine((Composite)mergeComposite, Messages.TemplateCreationRolesPage_MergeLine);
    }

    @Override
    protected String getValidationMessage() {
        TemplatePattern pattern;
        String result = super.getValidationMessage();
        if (result == null && (pattern = ((AbstractBijectiveTemplatePatternSpecification)this.getData()).getPattern()) != null && !pattern.getRoles().isEmpty()) {
            boolean first = true;
            for (TemplatePatternRole role : pattern.getRoles()) {
                if (first) {
                    first = false;
                    result = this.getFirstRoleValidationMessage(role);
                } else {
                    result = this.getSecondaryRoleValidationMessage(role);
                }
                if (result != null) break;
            }
        }
        return result;
    }

    protected String getFirstRoleValidationMessage(TemplatePatternRole role_p) {
        String result = null;
        if (role_p.getMergeDerivationRule() != null) {
            result = Messages.TemplateCreationRolesPage_FirstRoleNoCollectionRule;
        } else if (role_p.getTemplateElements().size() != 1) {
            result = Messages.TemplateCreationRolesPage_FirstRoleSingleElement;
        }
        return result;
    }

    protected String getSecondaryRoleValidationMessage(TemplatePatternRole role_p) {
        String result = null;
        if (role_p.getMergeDerivationRule() == null) {
            result = String.format(Messages.TemplateCreationRolesPage_SecondaryRoleCollectionRule, role_p.getName());
        }
        return result;
    }
}

