/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class DefaultComparisonMethod
implements IComparisonMethod {
    private boolean _initialized;
    private final Map<Role, IModelScopeDefinition> _roleToScopeDefinition = new HashMap<Role, IModelScopeDefinition>();
    private Role _twoWayReferenceRole;
    private IMatchPolicy _matchPolicy;
    private IDiffPolicy _diffPolicy;
    private IMergePolicy _mergePolicy;
    private EditingDomain _editingDomain;
    protected boolean _isDedicatedEditingDomain;

    public DefaultComparisonMethod(IModelScopeDefinition leftScopeSpec_p, IModelScopeDefinition rightScopeSpec_p, IModelScopeDefinition ancestorScopeSpec_p) {
        this._roleToScopeDefinition.put(Role.TARGET, leftScopeSpec_p);
        this._roleToScopeDefinition.put(Role.REFERENCE, rightScopeSpec_p);
        this._roleToScopeDefinition.put(Role.ANCESTOR, ancestorScopeSpec_p);
        this._twoWayReferenceRole = null;
        this._editingDomain = null;
        this._isDedicatedEditingDomain = false;
        this._matchPolicy = this.createMatchPolicy();
        this._diffPolicy = this.createDiffPolicy();
        this._mergePolicy = this.createMergePolicy();
        this._initialized = false;
    }

    protected void clearResourceSet(ResourceSet resourceSet_p) {
        ArrayList resources = new ArrayList(resourceSet_p.getResources());
        for (Resource resource : resources) {
            for (Adapter adapter : new ArrayList(resource.eAdapters())) {
                if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                resource.eAdapters().remove((Object)adapter);
            }
        }
        for (Resource resource : resources) {
            try {
                if (resource.isLoaded()) {
                    resource.unload();
                }
                resourceSet_p.getResources().remove((Object)resource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void configure() {
    }

    public AbstractComparisonViewer createComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        ComparisonViewer result = new ComparisonViewer(parent_p, actionBars_p);
        ILabelProvider customLP = this.getCustomLabelProvider();
        if (customLP != null) {
            result.setDelegateLabelProvider(customLP);
        }
        return result;
    }

    protected IDiffPolicy createDiffPolicy() {
        return null;
    }

    protected EditingDomain createEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
    }

    protected IMatchPolicy createMatchPolicy() {
        return null;
    }

    protected IMergePolicy createMergePolicy() {
        return null;
    }

    public void dispose() {
        ComposedAdapterFactory composed;
        AdapterFactory afForType;
        AdapterFactory af;
        AdapterFactoryEditingDomain afed;
        AdapterFactory af2;
        final EditingDomain domain = this.getEditingDomain();
        if (domain != null && this._isDedicatedEditingDomain) {
            MiscUtil.executeAndForget(domain, new Runnable(){

                public void run() {
                    DefaultComparisonMethod.this.clearResourceSet(domain.getResourceSet());
                }
            });
            domain.getCommandStack().flush();
        }
        if (domain instanceof AdapterFactoryEditingDomain && domain.getResourceSet().getResources().isEmpty() && (af2 = (afed = (AdapterFactoryEditingDomain)domain).getAdapterFactory()) instanceof IDisposable) {
            ((IDisposable)af2).dispose();
        }
        if (domain instanceof TransactionalEditingDomain && this._isDedicatedEditingDomain) {
            ((TransactionalEditingDomain)domain).dispose();
        }
        if ((af = EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider().getAdapterFactory()) instanceof ComposedAdapterFactory && (afForType = (composed = (ComposedAdapterFactory)af).getFactoryForType((Object)Resource.class.getPackage())) instanceof ResourceItemProviderAdapterFactory) {
            ResourceItemProviderAdapterFactory ripaf = (ResourceItemProviderAdapterFactory)afForType;
            ripaf.dispose();
        }
    }

    protected EditingDomain doGetEditingDomain() {
        this._isDedicatedEditingDomain = true;
        return this.createEditingDomain();
    }

    public IModelScopeDefinition getModelScopeDefinition(Role role_p) {
        return this._roleToScopeDefinition.get(role_p);
    }

    public final IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    public final EditingDomain getEditingDomain() {
        if (!this._initialized) {
            this._editingDomain = this.doGetEditingDomain();
            this._initialized = true;
        }
        return this._editingDomain;
    }

    protected ILabelProvider getCustomLabelProvider() {
        return null;
    }

    public final IMatchPolicy getMatchPolicy() {
        return this._matchPolicy;
    }

    public final IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    public ResourceSet getResourceSet(Role role_p) {
        return null;
    }

    public Role getTwoWayReferenceRole() {
        return this._twoWayReferenceRole;
    }

    public boolean isConfigurable() {
        return false;
    }

    public final boolean isThreeWay() {
        return this.getModelScopeDefinition(Role.ANCESTOR) != null;
    }

    public void setTwoWayReferenceRole(Role role_p) {
        if (!this.isThreeWay() && Role.TARGET == role_p || Role.REFERENCE == role_p) {
            this._twoWayReferenceRole = role_p;
        }
    }

    public boolean swapScopeDefinitions(Role role1_p, Role role2_p) {
        boolean result = false;
        IModelScopeDefinition scope1 = this.getModelScopeDefinition(role1_p);
        IModelScopeDefinition scope2 = this.getModelScopeDefinition(role2_p);
        if (scope1 != null && scope2 != null) {
            this._roleToScopeDefinition.put(role1_p, scope2);
            this._roleToScopeDefinition.put(role2_p, scope1);
            result = true;
        }
        return result;
    }
}

