/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.setup;

import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.IPersistentDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.InconsistencyDialog;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;

public class EMFDiffMergeEditorInput
extends CompareEditorInput
implements IEditingDomainProvider {
    protected IComparisonMethod<?> _comparisonMethod;
    protected Resource _comparisonResource;
    protected IEditableTreeDataScope<?> _leftScope;
    protected IEditableTreeDataScope<?> _rightScope;
    protected IEditableTreeDataScope<?> _ancestorScope;
    protected AbstractComparisonViewer _viewer;
    private boolean _foundDifferences;
    private boolean _isDirty;
    protected PropertySheetPage _propertySheetPage;
    protected CommandStackListener _commandStackListener;
    private ICompareNavigator _navigator;

    public EMFDiffMergeEditorInput(IComparisonMethod<?> method_p) {
        super(new CompareConfiguration());
        this._comparisonMethod = method_p;
        this._leftScope = null;
        this._rightScope = null;
        this._ancestorScope = null;
        this._comparisonResource = null;
        this._foundDifferences = true;
        this._isDirty = false;
        this._navigator = this.createNavigator();
        this.initializeCompareConfiguration();
    }

    public boolean canRunAsJob() {
        return true;
    }

    public void checkInconsistency(IComparison<?> comparison_p) {
        if (comparison_p != null && !comparison_p.isConsistent()) {
            this.handleInconsistency(comparison_p);
        }
    }

    protected void checkStatus(IStatus status_p) {
        if (!status_p.isOK()) {
            throw new RuntimeException(status_p.getMessage(), status_p.getException());
        }
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this._viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent ev) {
                EMFDiffMergeEditorInput.this.handleDispose();
            }
        });
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
    }

    public Control createContents(Composite parent_p) {
        this._viewer = this._comparisonMethod.createComparisonViewer(parent_p, this.getActionBars());
        this._viewer.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                String propertyName = event_p.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean dirty = (Boolean)event_p.getNewValue();
                    EMFDiffMergeEditorInput.this.setDirty(dirty);
                }
            }
        });
        this._viewer.setInput(this.getCompareResult());
        this.contentsCreated();
        return this._viewer.getControl();
    }

    protected ICompareNavigator createNavigator() {
        return new ICompareNavigator(){

            public boolean selectChange(boolean next_p) {
                int change;
                boolean result = false;
                int n = change = next_p ? 1 : 2;
                if (EMFDiffMergeEditorInput.this._viewer != null) {
                    result = EMFDiffMergeEditorInput.this._viewer.getNavigatable().selectChange(change);
                }
                return result;
            }
        };
    }

    protected String createTitle() {
        Role leftRole = this.getLeftRole();
        String leftDesc = this._comparisonMethod.getModelScopeDefinition(leftRole).getShortLabel();
        String rightDesc = this._comparisonMethod.getModelScopeDefinition(leftRole.opposite()).getShortLabel();
        String result = String.format(Messages.EMFDiffMergeEditorInput_Title, leftDesc, rightDesc);
        return result;
    }

    protected void disposeResources() {
        EditingDomain domain = this.getEditingDomain();
        final MiscUtil.ExtendedUnloader unloader = MiscUtil.ExtendedUnloader.getDefault();
        final HashSet unloaded = new HashSet();
        MiscUtil.executeAndForget(domain, new Runnable(){

            @Override
            public void run() {
                if (EMFDiffMergeEditorInput.this._comparisonResource != null) {
                    unloader.unloadResource(EMFDiffMergeEditorInput.this._comparisonResource, true);
                    unloaded.add(EMFDiffMergeEditorInput.this._comparisonResource);
                }
                LinkedList localUnloaded = new LinkedList();
                if (EMFDiffMergeEditorInput.this._leftScope instanceof IPersistentDataScope) {
                    localUnloaded.addAll(((IPersistentDataScope)EMFDiffMergeEditorInput.this._leftScope).unload());
                }
                if (EMFDiffMergeEditorInput.this._rightScope instanceof IPersistentDataScope) {
                    localUnloaded.addAll(((IPersistentDataScope)EMFDiffMergeEditorInput.this._rightScope).unload());
                }
                if (EMFDiffMergeEditorInput.this._ancestorScope instanceof IPersistentDataScope) {
                    localUnloaded.addAll(((IPersistentDataScope)EMFDiffMergeEditorInput.this._ancestorScope).unload());
                }
                for (Object localUnloadedElement : localUnloaded) {
                    if (!(localUnloadedElement instanceof Resource)) continue;
                    unloaded.add((Resource)localUnloadedElement);
                }
            }
        });
        if (domain != null) {
            domain.getCommandStack().flush();
        }
        unloader.disconnectResources(domain, unloaded);
    }

    protected void flushViewers(IProgressMonitor monitor_p) {
        this._viewer.flush(monitor_p);
    }

    public boolean foundDifferences() {
        return this._foundDifferences;
    }

    public EMFDiffNode getCompareResult() {
        return (EMFDiffNode)super.getCompareResult();
    }

    public IComparisonMethod<?> getComparisonMethod() {
        return this._comparisonMethod;
    }

    public EditingDomain getEditingDomain() {
        return this._comparisonMethod != null ? this._comparisonMethod.getEditingDomain() : null;
    }

    protected Role getLeftRole() {
        return this._comparisonMethod != null ? this._comparisonMethod.getLeftRole() : null;
    }

    public synchronized ICompareNavigator getNavigator() {
        return this._navigator;
    }

    protected IPropertySheetPage getPropertySheetPage() {
        EditingDomain domain;
        if (this._propertySheetPage == null && (domain = this.getEditingDomain()) instanceof AdapterFactoryEditingDomain) {
            AdapterFactoryEditingDomain afDomain = (AdapterFactoryEditingDomain)domain;
            this._propertySheetPage = new PropertySheetPage(afDomain);
            this._propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(afDomain.getAdapterFactory()));
            this._commandStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject event_p) {
                    Shell shell = EMFDiffMergeEditorInput.this.getShell();
                    if (shell != null) {
                        shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).EMFDiffMergeEditorInput.this._propertySheetPage != null && (this).EMFDiffMergeEditorInput.this._propertySheetPage.getControl() != null && !(this).EMFDiffMergeEditorInput.this._propertySheetPage.getControl().isDisposed()) {
                                    (this).EMFDiffMergeEditorInput.this._propertySheetPage.refresh();
                                }
                            }
                        });
                    }
                }
            };
            afDomain.getCommandStack().addCommandStackListener(this._commandStackListener);
        }
        return this._propertySheetPage;
    }

    protected Shell getShell() {
        Shell result = null;
        IWorkbenchSite site = this.getSite();
        if (site != null) {
            result = site.getShell();
        }
        return result;
    }

    protected IWorkbenchSite getSite() {
        IWorkbenchPartSite result = null;
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null) {
            result = part.getSite();
        }
        return result;
    }

    public AbstractComparisonViewer getViewer() {
        return this._viewer;
    }

    protected void handleDispose() {
        boolean inUIThread;
        this._navigator = null;
        Display display = Display.getDefault();
        if (this._propertySheetPage != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EMFDiffMergeEditorInput.this._propertySheetPage.dispose();
                }
            });
        }
        this._viewer = null;
        if (this._commandStackListener != null && this.getEditingDomain() != null) {
            this.getEditingDomain().getCommandStack().removeCommandStackListener(this._commandStackListener);
        }
        super.handleDispose();
        Runnable disposeBehavior = new Runnable(){

            @Override
            public void run() {
                if (EMFDiffMergeEditorInput.this.getCompareResult() != null) {
                    EMFDiffMergeEditorInput.this.getCompareResult().dispose();
                }
                EMFDiffMergeEditorInput.this.disposeResources();
                if (EMFDiffMergeEditorInput.this._comparisonMethod != null) {
                    EMFDiffMergeEditorInput.this._comparisonMethod.dispose();
                }
                EMFDiffMergeEditorInput.this._comparisonMethod = null;
                EMFDiffMergeEditorInput.this._ancestorScope = null;
                EMFDiffMergeEditorInput.this._leftScope = null;
                EMFDiffMergeEditorInput.this._rightScope = null;
                EMFDiffMergeEditorInput.this._comparisonResource = null;
            }
        };
        boolean bl = inUIThread = display.getThread() == Thread.currentThread();
        if (inUIThread) {
            BusyIndicator.showWhile((Display)display, (Runnable)disposeBehavior);
        } else {
            disposeBehavior.run();
        }
        try {
            super.run(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleExecutionProblem(Throwable problem_p) {
        String message;
        Throwable diagnostic = problem_p;
        if (diagnostic instanceof WrappedException) {
            diagnostic = ((WrappedException)diagnostic).exception();
        }
        if (diagnostic instanceof PackageNotFoundException) {
            PackageNotFoundException pnfe = (PackageNotFoundException)diagnostic;
            message = MiscUtil.buildString(Messages.EMFDiffMergeEditorInput_WrongMetamodel, "\n", pnfe.getLocation(), ".\n", Messages.EMFDiffMergeEditorInput_MigrationNeeded);
        } else {
            String msg = diagnostic.getLocalizedMessage();
            if (msg == null) {
                msg = diagnostic.toString();
            }
            message = MiscUtil.buildString(Messages.EMFDiffMergeEditorInput_Failure, "\n", msg);
        }
        final Shell shell = this.getShell();
        if (shell != null) {
            final String finalMessage = message;
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)EMFDiffMergeUIPlugin.LABEL, (String)finalMessage);
                }
            });
        }
    }

    protected void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        Role leftRole = this.getLeftRole();
        IModelScopeDefinition leftScopeDefinition = this._comparisonMethod.getModelScopeDefinition(leftRole);
        IModelScopeDefinition rightScopeDefinition = this._comparisonMethod.getModelScopeDefinition(leftRole.opposite());
        IModelScopeDefinition ancestorDefinition = this._comparisonMethod.getModelScopeDefinition(Role.ANCESTOR);
        cc.setLeftLabel(leftScopeDefinition.getLabel());
        cc.setRightLabel(rightScopeDefinition.getLabel());
        cc.setAncestorLabel(ancestorDefinition == null ? "" : ancestorDefinition.getLabel());
        cc.setLeftEditable(leftScopeDefinition.isEditable());
        cc.setRightEditable(rightScopeDefinition.isEditable());
    }

    protected GComparison<?, ?, ?> initializeComparison() {
        boolean leftIsTarget = this.getLeftRole() == Role.TARGET;
        IEditableTreeDataScope<?> targetScope = leftIsTarget ? this._leftScope : this._rightScope;
        IEditableTreeDataScope<?> referenceScope = leftIsTarget ? this._rightScope : this._leftScope;
        GComparison<?, ?, ?> result = this._comparisonMethod.createComparison(targetScope, referenceScope, this._ancestorScope);
        return result;
    }

    protected EMFDiffNode initializeDiffNode(GComparison<?, ?, ?> comparison_p) {
        ResourceSet resourceSet;
        ResourceSet resourceSet2 = resourceSet = this.getEditingDomain() != null ? this.getEditingDomain().getResourceSet() : null;
        if (resourceSet != null) {
            URI defaultURI = URI.createPlatformResourceURI((String)"comparison/comparison", (boolean)true);
            defaultURI = defaultURI.appendFileExtension("edm");
            this._comparisonResource = resourceSet.createResource(defaultURI);
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        EMFDiffNode result = new EMFDiffNode(comparison_p, this.getEditingDomain(), cc.isLeftEditable(), cc.isRightEditable(), this._comparisonMethod.getLeftRole());
        result.setReferenceRole(this._comparisonMethod.getTwoWayReferenceRole());
        result.setEditorInput((IEditorInput)this);
        return result;
    }

    public boolean isSaveNeeded() {
        return this._isDirty;
    }

    protected void loadScopes(IProgressMonitor monitor_p) {
        EditingDomain domain = this.getEditingDomain();
        boolean threeWay = this._comparisonMethod.isThreeWay();
        Role leftRole = this.getLeftRole();
        String mainTaskName = Messages.EMFDiffMergeEditorInput_Loading;
        SubMonitor loadingMonitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)mainTaskName, (int)(threeWay ? 4 : 3));
        loadingMonitor.worked(1);
        loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingLeft);
        EditingDomain leftLoadingContext = domain != null ? domain : this._comparisonMethod.getResourceSet(leftRole);
        this._leftScope = this._comparisonMethod.getModelScopeDefinition(leftRole).createScope(leftLoadingContext);
        if (this._leftScope == null) {
            throw new RuntimeException(Messages.EMFDiffMergeEditorInput_LeftScopeNull);
        }
        if (this._leftScope instanceof IPersistentDataScope) {
            IStatus status = ((IPersistentDataScope)this._leftScope).load();
            this.checkStatus(status);
        }
        loadingMonitor.worked(1);
        if (loadingMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingRight);
        EditingDomain rightLoadingContext = domain != null ? domain : this._comparisonMethod.getResourceSet(leftRole.opposite());
        this._rightScope = this._comparisonMethod.getModelScopeDefinition(leftRole.opposite()).createScope(rightLoadingContext);
        if (this._rightScope == null) {
            throw new RuntimeException(Messages.EMFDiffMergeEditorInput_RightScopeNull);
        }
        if (this._rightScope instanceof IPersistentDataScope) {
            IStatus status = ((IPersistentDataScope)this._rightScope).load();
            this.checkStatus(status);
        }
        loadingMonitor.worked(1);
        if (loadingMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (threeWay) {
            loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingAncestor);
            EditingDomain ancestorLoadingContext = domain != null ? domain : this._comparisonMethod.getResourceSet(Role.ANCESTOR);
            this._ancestorScope = this._comparisonMethod.getModelScopeDefinition(Role.ANCESTOR).createScope(ancestorLoadingContext);
            if (this._ancestorScope == null) {
                throw new RuntimeException(Messages.EMFDiffMergeEditorInput_AncestorScopeNull);
            }
            if (this._ancestorScope instanceof IPersistentDataScope) {
                IStatus status = ((IPersistentDataScope)this._ancestorScope).load();
                this.checkStatus(status);
            }
            loadingMonitor.worked(1);
            if (loadingMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    public boolean mergeIsComplete() {
        return !this.isDirty() && (this._viewer.getInput() == null || this._viewer.getInput().isEmpty());
    }

    protected Object prepareInput(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        if (monitor_p == null) {
            return null;
        }
        String title = this.createTitle();
        this.setTitle(title);
        boolean scopesReady = this._leftScope != null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)EMFDiffMergeUIPlugin.LABEL, (int)2);
        EMFDiffNode result = null;
        try {
            if (!scopesReady) {
                this.loadScopes((IProgressMonitor)monitor.newChild(1));
            }
            GComparison<?, ?, ?> comparison = this.initializeComparison();
            comparison.compute(this._comparisonMethod.getMatchPolicy(), this._comparisonMethod.getDiffPolicy(), this._comparisonMethod.getMergePolicy(), (IProgressMonitor)monitor.newChild(scopesReady ? 2 : 1));
            this.checkInconsistency((IComparison<?>)comparison);
            this._foundDifferences = comparison.hasRemainingDifferences();
            if (this._foundDifferences) {
                result = this.initializeDiffNode(comparison);
            } else {
                this.handleDispose();
            }
        }
        catch (OperationCanceledException e) {
            this.handleDispose();
        }
        catch (Throwable t) {
            this.setMessage(Messages.EMFDiffMergeEditorInput_CannotLoad);
            this.handleExecutionProblem(t);
            this.handleDispose();
        }
        return result;
    }

    protected void handleInconsistency(final IComparison<?> comparison_p) {
        final Shell shell = this.getShell();
        if (shell != null) {
            final int[] pressed = new int[1];
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(shell, EMFDiffMergeUIPlugin.LABEL, null, Messages.InconsistencyDialog_DuplicateIDs, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
                    pressed[0] = dialog.open();
                }
            });
            if (pressed[0] != 0) {
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        InconsistencyDialog dialog = new InconsistencyDialog(shell, comparison_p);
                        dialog.open();
                    }
                });
            }
        }
    }

    public void run(IProgressMonitor monitor_p) throws InterruptedException, InvocationTargetException {
        EditingDomain domain;
        if (this.getCompareResult() != null) {
            this.getCompareResult().dispose();
        }
        super.run(monitor_p);
        if (this.getCompareResult() != null && this.foundDifferences() && this._comparisonResource != null && (domain = this.getEditingDomain()) != null) {
            MiscUtil.executeAndForget(domain, new Runnable(){

                @Override
                public void run() {
                    UIComparison uiComparison = EMFDiffMergeEditorInput.this.getCompareResult().getUIComparison();
                    EMFDiffMergeEditorInput.this._comparisonResource.getContents().add((Object)uiComparison);
                    EMFDiffMergeEditorInput.this._comparisonResource.getContents().add(uiComparison.getActualComparison());
                }
            });
            domain.getCommandStack().flush();
        }
    }

    public void setComparisonMethod(IComparisonMethod<?> comparisonMethod_p) {
        EditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            boolean dedicated = this._comparisonMethod == null ? false : this._comparisonMethod.isDedicatedEditingDomain();
            comparisonMethod_p.setEditingDomain(domain, dedicated);
        }
        this._comparisonMethod = comparisonMethod_p;
    }

    public void setDirty(boolean dirty_p) {
        boolean oldDirty = this.isDirty();
        if (dirty_p != oldDirty) {
            this._isDirty = dirty_p;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)oldDirty, (Object)this._isDirty);
            this.firePropertyChange(event);
        }
    }

    public boolean setFocus2() {
        boolean result = false;
        if (this._viewer != null) {
            result = this._viewer.getControl().setFocus();
        }
        return result;
    }

    protected static class PropertySheetPage
    extends ExtendedPropertySheetPage {
        protected ISelectionService _selectionService = null;

        protected PropertySheetPage(AdapterFactoryEditingDomain editingDomain_p) {
            super(editingDomain_p);
        }

        public void dispose() {
            super.dispose();
            if (this._selectionService != null) {
                this._selectionService.removeSelectionListener((ISelectionListener)this);
                this._selectionService = null;
            }
        }

        protected PropertySheet getPropertySheet(IWorkbenchPart part_p) {
            IViewPart view;
            IViewReference ref;
            IWorkbenchPage page;
            PropertySheet result = null;
            IWorkbenchPartSite site = part_p.getSite();
            if (site != null && (page = site.getPage()) != null && (ref = page.findViewReference("org.eclipse.ui.views.PropertySheet")) != null && (view = ref.getView(false)) instanceof PropertySheet) {
                result = (PropertySheet)view;
            }
            return result;
        }

        public void init(IPageSite pageSite_p) {
            super.init(pageSite_p);
            this._selectionService = pageSite_p.getWorkbenchWindow().getSelectionService();
            if (this._selectionService != null) {
                this._selectionService.addSelectionListener((ISelectionListener)this);
            }
        }

        public void selectionChanged(IWorkbenchPart part_p, ISelection selection_p) {
            PropertySheet propertiesView = this.getPropertySheet(part_p);
            if (propertiesView != null && !propertiesView.isPinned() && !selection_p.isEmpty()) {
                super.selectionChanged(part_p, selection_p);
            }
        }
    }
}

