/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.diffmerge.structures.common.FLinkedList;
import org.eclipse.emf.diffmerge.structures.endo.AbstractEndorelationIterator;
import org.eclipse.emf.diffmerge.structures.endo.IRecursivelyDefinedEndorelation;

public class DepthFirstIterator<T>
extends AbstractEndorelationIterator<T> {
    protected final Deque<Iterator<T>> _iterationStack = new LinkedList<Iterator<T>>();
    protected final LinkedList<T> _lastPath;
    protected final LinkedList<T> _nextPath;

    public DepthFirstIterator(IRecursivelyDefinedEndorelation<T> endorelation_p) {
        super(endorelation_p);
        Iterator originsIterator = this._endorelation.getOrigins().iterator();
        this._iterationStack.add(originsIterator);
        this._lastPath = new FLinkedList<T>(this._endorelation.getEqualityTester());
        this._nextPath = new FLinkedList<T>(this._endorelation.getEqualityTester());
        this.update();
    }

    @Override
    public List<T> lastPath() {
        return Collections.unmodifiableList(this._lastPath);
    }

    @Override
    public T next() {
        this._lastPath.clear();
        this._lastPath.addAll(this._nextPath);
        Object result = super.next();
        return result;
    }

    @Override
    public List<T> nextPath() {
        return Collections.unmodifiableList(this._nextPath);
    }

    public void prune() {
        if (this.nextDepth() > this.lastDepth()) {
            this._iterationStack.removeFirst();
            this._iterationStack.addFirst(this.emptyIterator());
            this._next = null;
            this.update();
        }
    }

    @Override
    protected void update() {
        while (this._next == null && !this._iterationStack.isEmpty()) {
            Iterator<T> topIterator = this._iterationStack.peekFirst();
            this._next = this.getNextThrough(topIterator);
            if (this._next == null) {
                this._iterationStack.removeFirst();
                --this._nextDepth;
                if (!this._nextPath.isEmpty()) {
                    this._nextPath.removeLast();
                }
            } else {
                Collection<Object> nextElements = this._endorelation.get(this._next);
                Iterator<Object> newTopIterator = nextElements.iterator();
                this._iterationStack.addFirst(newTopIterator);
                if (!newTopIterator.hasNext()) {
                    this._maximalElements.add(this._next);
                }
            }
            if (this._next == null) continue;
            ++this._nextDepth;
            this._nextPath.addLast(this._next);
        }
        if (this._next == null) {
            this._nextDepth = -1L;
        }
    }
}

