/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.ClientConfiguration;
import org.eclipse.datatools.enablement.ibm.util.ClientStrategyResolverException;
import org.eclipse.datatools.enablement.ibm.util.ClientStrategyService;
import org.eclipse.datatools.enablement.ibm.util.IClientStrategy;
import org.eclipse.datatools.enablement.ibm.util.IQueryMap;
import org.eclipse.datatools.enablement.ibm.util.QueryExecutionEngine;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ClientStrategyResolver {
    private static ClientStrategyResolver resolver;

    private ClientStrategyResolver() {
    }

    public static synchronized ClientStrategyResolver getInstance() {
        if (resolver == null) {
            resolver = new ClientStrategyResolver();
        }
        return resolver;
    }

    public EList getObjects(EObject object, EStructuralFeature feature, ClientConfiguration configuration) throws ClientStrategyResolverException {
        Object result = this.getObject(object, feature, configuration);
        if (result instanceof EList) {
            return (EList)result;
        }
        throw new ClientStrategyResolverException("A list was expected, but only one object was returned");
    }

    public Object getObject(EObject object, EStructuralFeature feature, ClientConfiguration configuration) {
        IClientStrategy strategy = ClientStrategyService.getInstance().getClientStrategy(object, configuration);
        if (strategy != null) {
            ICatalogQuery[] queries = strategy.getCatalogQueries(object, feature);
            this.realizeQueries(object, queries);
        }
        return object.eGet(feature);
    }

    public void loadObject(EObject object, IQueryMap.QueryType queryType, ClientConfiguration configuration) {
        IClientStrategy strategy = ClientStrategyService.getInstance().getClientStrategy(object, configuration);
        if (strategy == null) {
            return;
        }
        ICatalogQuery[] queries = strategy.getCatalogQueries(object, queryType);
        this.realizeQueries(object, queries);
    }

    private void realizeQueries(EObject object, ICatalogQuery[] queries) {
        if (queries != null && queries.length > 0) {
            QueryExecutionEngine.realizeQueries(object, queries);
        }
    }
}

