/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.zip.CRC32;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;

public class CRCVisitor
extends ApiDescriptionVisitor {
    private CRC32 fCrc = new CRC32();

    @Override
    public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
        String signature = null;
        String name = null;
        switch (element.getElementType()) {
            case 2: {
                signature = ((IReferenceTypeDescriptor)element).getSignature();
                break;
            }
            case 6: {
                signature = ((IMethodDescriptor)element).getSignature();
                name = ((IMethodDescriptor)element).getName();
                break;
            }
            case 5: {
                name = ((IFieldDescriptor)element).getName();
                break;
            }
        }
        if (signature != null) {
            this.fCrc.update(signature.getBytes());
        }
        if (name != null) {
            this.fCrc.update(name.getBytes());
        }
        this.fCrc.update(description.getRestrictions());
        this.fCrc.update(description.getVisibility());
        return true;
    }

    public long getValue() {
        return this.fCrc.getValue();
    }
}

