/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.Set;
import org.eclipse.xtext.util.JUnitVersion;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xtext.wizard.BuildSystem;
import org.eclipse.xtext.xtext.wizard.Ecore2XtextConfiguration;
import org.eclipse.xtext.xtext.wizard.IdeProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.LanguageDescriptor;
import org.eclipse.xtext.xtext.wizard.LanguageServer;
import org.eclipse.xtext.xtext.wizard.P2RepositoryProject;
import org.eclipse.xtext.xtext.wizard.ParentProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectLayout;
import org.eclipse.xtext.xtext.wizard.RuntimeProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.SdkFeatureProject;
import org.eclipse.xtext.xtext.wizard.SourceLayout;
import org.eclipse.xtext.xtext.wizard.TargetPlatformProject;
import org.eclipse.xtext.xtext.wizard.TestedProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.UiProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.WebProjectDescriptor;

public class WizardConfiguration {
    private String rootLocation;
    private String baseName;
    private XtextVersion xtextVersion = XtextVersion.getCurrent();
    private final Ecore2XtextConfiguration ecore2Xtext = new Ecore2XtextConfiguration();
    private Charset encoding = Charset.defaultCharset();
    private String lineDelimiter = Strings.newLine();
    private BuildSystem preferredBuildSystem = BuildSystem.NONE;
    private SourceLayout sourceLayout = SourceLayout.PLAIN;
    private ProjectLayout projectLayout = ProjectLayout.FLAT;
    private boolean needsGradleWrapper = true;
    private JavaVersion javaVersion = JavaVersion.JAVA8;
    private LanguageServer languageServer = LanguageServer.NONE;
    private JUnitVersion junitVersion = JUnitVersion.DEFAULT;
    private final LanguageDescriptor language = new LanguageDescriptor();
    private final RuntimeProjectDescriptor runtimeProject = new RuntimeProjectDescriptor(this);
    private final IdeProjectDescriptor ideProject = new IdeProjectDescriptor(this);
    private final UiProjectDescriptor uiProject = new UiProjectDescriptor(this);
    private final WebProjectDescriptor webProject = new WebProjectDescriptor(this);
    private final ParentProjectDescriptor parentProject = new ParentProjectDescriptor(this);
    private final TargetPlatformProject targetPlatformProject = new TargetPlatformProject(this);
    private final SdkFeatureProject sdkProject = new SdkFeatureProject(this);
    private final P2RepositoryProject p2Project = new P2RepositoryProject(this);

    public Set<ProjectDescriptor> getEnabledProjects() {
        Iterable productionProjects = Iterables.filter((Iterable)Lists.newArrayList((Object[])new ProjectDescriptor[]{this.parentProject, this.runtimeProject, this.ideProject, this.uiProject, this.webProject, this.targetPlatformProject, this.sdkProject, this.p2Project}), ProjectDescriptor::isEnabled);
        Iterable testProjects = Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)productionProjects, TestedProjectDescriptor.class), TestedProjectDescriptor::getTestProject), it -> it.isEnabled() && it.isSeparate());
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)productionProjects, (Iterable)testProjects));
    }

    public boolean needsMavenBuild() {
        return BuildSystem.MAVEN.equals((Object)this.preferredBuildSystem) || BuildSystem.GRADLE.equals((Object)this.preferredBuildSystem) && this.uiProject.isEnabled();
    }

    public boolean needsTychoBuild() {
        return this.needsMavenBuild() && this.runtimeProject.isEclipsePluginProject();
    }

    public boolean needsGradleBuild() {
        return BuildSystem.GRADLE.equals((Object)this.preferredBuildSystem);
    }

    public boolean isNeedsGradleWrapper() {
        return this.needsGradleWrapper && this.needsGradleBuild();
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    public void setRootLocation(String rootLocation) {
        this.rootLocation = rootLocation;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public XtextVersion getXtextVersion() {
        return this.xtextVersion;
    }

    public void setXtextVersion(XtextVersion xtextVersion) {
        this.xtextVersion = xtextVersion;
    }

    public Ecore2XtextConfiguration getEcore2Xtext() {
        return this.ecore2Xtext;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public BuildSystem getPreferredBuildSystem() {
        return this.preferredBuildSystem;
    }

    public void setPreferredBuildSystem(BuildSystem preferredBuildSystem) {
        this.preferredBuildSystem = preferredBuildSystem;
    }

    public SourceLayout getSourceLayout() {
        return this.sourceLayout;
    }

    public void setSourceLayout(SourceLayout sourceLayout) {
        this.sourceLayout = sourceLayout;
    }

    public ProjectLayout getProjectLayout() {
        return this.projectLayout;
    }

    public void setProjectLayout(ProjectLayout projectLayout) {
        this.projectLayout = projectLayout;
    }

    public void setNeedsGradleWrapper(boolean needsGradleWrapper) {
        this.needsGradleWrapper = needsGradleWrapper;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public LanguageServer getLanguageServer() {
        return this.languageServer;
    }

    public void setLanguageServer(LanguageServer languageServer) {
        this.languageServer = languageServer;
    }

    public JUnitVersion getJunitVersion() {
        return this.junitVersion;
    }

    public void setJunitVersion(JUnitVersion junitVersion) {
        this.junitVersion = junitVersion;
    }

    public LanguageDescriptor getLanguage() {
        return this.language;
    }

    public RuntimeProjectDescriptor getRuntimeProject() {
        return this.runtimeProject;
    }

    public IdeProjectDescriptor getIdeProject() {
        return this.ideProject;
    }

    public UiProjectDescriptor getUiProject() {
        return this.uiProject;
    }

    public WebProjectDescriptor getWebProject() {
        return this.webProject;
    }

    public ParentProjectDescriptor getParentProject() {
        return this.parentProject;
    }

    public TargetPlatformProject getTargetPlatformProject() {
        return this.targetPlatformProject;
    }

    public SdkFeatureProject getSdkProject() {
        return this.sdkProject;
    }

    public P2RepositoryProject getP2Project() {
        return this.p2Project;
    }
}

